/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

public class CanOpenNode {
    private final String nodeID;
    private String type;
    private String vendorID;
    private String productCode;
    private String revisionNB;
    private String serialNB;
    private boolean identified;

    public CanOpenNode(String id) {
        this.nodeID = id;
        this.type = "0";
        this.vendorID = "0";
        this.productCode = "0";
        this.revisionNB = "0";
        this.serialNB = "0";
        this.identified = false;
    }

    public CanOpenNode(String nodeID, String serialNB) {
        this.nodeID = nodeID;
        this.serialNB = serialNB;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getType() {
        return this.type;
    }

    public String getVendorID() {
        return this.vendorID;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getRevisionNB() {
        return this.revisionNB;
    }

    public String getSerialNB() {
        return this.serialNB;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public void setNodeInfo(String type, String vendor, String code, String revision, String serial) {
        this.type = type;
        this.vendorID = vendor;
        this.productCode = code;
        this.revisionNB = revision;
        this.serialNB = serial;
        this.identified = !"0".equals(serial);
    }

    public boolean isADC() {
        return "40191".equals(this.type);
    }

    public boolean isDAC() {
        return "80191".equals(this.type);
    }

    public boolean isMaxonMotor() {
        return "20192".equals(this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Node ID= ");
        sb.append(this.nodeID);
        String dec = String.format(" (in decimal= %d)", Integer.parseInt(this.nodeID, 16));
        sb.append(dec);
        sb.append("/ type=");
        sb.append(this.getType());
        sb.append("/ vendor=");
        sb.append(this.getVendorID());
        sb.append("/ product code=");
        sb.append(this.getProductCode());
        sb.append("/ revision=");
        sb.append(this.getRevisionNB());
        sb.append("/ serial number=");
        sb.append(this.getSerialNB());
        return sb.toString();
    }
}

