/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.HashMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenEPOSOnlineClamp
extends CanOpenEPOS
implements EPOSControllerWithBrake {
    public CanOpenEPOSOnlineClamp(String nodeID, String serialNB, HashMap<String, Integer> paramsForCurrent, HashMap<String, Integer> paramsForProfilePosition, HashMap<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Activate brake to prevent clamp motion.")
    public void activateBrake() {
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2one(hexaValue, 15));
        FCSCst.FCSLOG.info((Object)(this.getName() + ": brake activated."));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release brake to be able to move clamp.")
    public void releaseBrake() {
        this.enable();
        this.doReleaseBrake();
    }

    @Override
    public void activateBrakeAndDisable() {
        this.activateBrake();
        this.disable();
    }

    @Override
    public void enableAndReleaseBrake() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void doReleaseBrake() {
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2zero(hexaValue, 15));
        FCSCst.FCSLOG.info((Object)(this.getName() + ": brake released."));
    }
}

