/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class MainModule
extends Module
implements AlertRaiser {
    protected BridgeToHardware bridge;
    protected AtomicBoolean haltRequired;
    protected AtomicBoolean stopRequired;

    public MainModule(BridgeToHardware bridge) {
        super(3000);
        this.bridge = bridge;
    }

    public boolean isHaltRequired() {
        return this.haltRequired.get();
    }

    public boolean isStopRequired() {
        return this.stopRequired.get();
    }

    public void initModule() {
        this.haltRequired = new AtomicBoolean(false);
        this.stopRequired = new AtomicBoolean(false);
        String msg = this.controlRealHardware() ? "Real Hardware" : "Simulation";
        FCSCst.FCSLOG.info((Object)(this.getName() + "==>" + msg));
    }

    public void postStart() throws HardwareException {
        super.postStart();
        FCSCst.FCSLOG.fine((Object)(this.getName() + ":postStart begins."));
        try {
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        FCSCst.FCSLOG.fine((Object)(this.getName() + ":postStart ends."));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if hardware is booted, identified and initialized.")
    public boolean isCANDevicesReady() {
        return this.bridge.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if this main module controls real hardware.")
    public boolean controlRealHardware() {
        return this.bridge.isRealHardware();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns the list of CANopen hardware managed by this subsystem.")
    public List<String> listHardwareNames() {
        return this.bridge.listHardwareNames();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the list of LOADER CANopen hardware managed by this subsystem.")
    public List<String> listLoaderHardwareNames() {
        return Collections.emptyList();
    }

    @Command(type=Command.CommandType.QUERY, description="Return the list of names of filters  that this subsystem manages.", level=1, alias="listFilterNames")
    public List<String> getFilterNames() {
        FilterManager filterManager = (FilterManager)((Object)this.getComponentLookup().getComponentByName("filterManager"));
        if (filterManager == null) {
            return Collections.emptyList();
        }
        return filterManager.getFilterNamesSortedByFilterID();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update state in reading sensors.")
    public void updateStateWithSensors() {
        this.bridge.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readiness state and publishes on the status bus.")
    public void updateFCSState() {
        if (this.isCANDevicesReady() && !this.getSubsystem().isInState((Enum)AlertState.ALARM)) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HARDWARE_READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }

    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                FCSCst.FCSLOG.debug((Object)"HALT required");
                this.haltRequired.set(true);
                break;
            }
            case STOP: {
                FCSCst.FCSLOG.debug((Object)"STOP required");
                this.stopRequired.set(true);
                break;
            }
            case RE_START: {
                this.haltRequired.set(false);
                this.stopRequired.set(false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return TreeWalkerDiag.GO;
    }
}

