/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;

public class InclinometerModule
extends Module {
    @ConfigurationParameter
    private final String plutoGatewayName;
    @ConfigurationParameter
    private final int byteNumero;
    private PlutoGatewayInterface plutoGateway;
    private double inclinaison;

    public InclinometerModule(String plutoGatewayName, int byteNumero) {
        this.plutoGatewayName = plutoGatewayName;
        this.byteNumero = byteNumero;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns inclinaison value in degrees. Doesn't read again CANopen device.")
    public double getInclinaison() {
        return this.inclinaison;
    }

    public void initModule() {
        FCSCst.FCSLOG.info((Object)(this.getName() + ": init MODULE"));
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        this.plutoGateway = (PlutoGatewayInterface)lookup.getComponentByName(this.plutoGatewayName);
    }

    public void updateInclinaison(String[] hexaValues) {
        String valueInHexa = hexaValues[this.byteNumero];
        this.inclinaison = InclinometerModule.convertVoltage2Degree(Integer.parseInt(valueInHexa, 16) / 10);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads new value for inclinometer and returns inclinaison.")
    public double readInclinaison() {
        this.plutoGateway.readNewHexaValues();
        this.updateInclinaison(this.plutoGateway.getHexaValues());
        return this.inclinaison;
    }

    private static double convertVoltage2Degree(int voltage) {
        if (voltage < 0 || voltage > 5) {
            throw new IllegalArgumentException(voltage + ": bad value for voltage. Voltage has to be between 0 and 5");
        }
        double sin_angle = ((double)voltage - 2.5) / 11.52;
        return Math.toDegrees(Math.asin(sin_angle));
    }
}

