/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import java.util.SortedMap;
import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;

public interface FilterLocator
extends UsesSubsystem {
    public static final String FILTER_CONFIG_CATEGORY = "filterLocation";

    public CarouselModule getCarousel();

    public FilterManager getFilterManager();

    @Command(type=Command.CommandType.QUERY, level=0, description="Check which filters are on Carousel and on which socket and update the sockets.", alias="locateFilters")
    default public void checkFiltersLocation() {
        FCSCst.FCSLOG.info((Object)(this.getName() + " updating filters location on carousel ....."));
        SortedMap<String, Filter> filtersMap = this.getFilterManager().getFiltersMapByName();
        for (Map.Entry entry : filtersMap.entrySet()) {
            Filter filter = (Filter)entry.getValue();
            filter.initializeFilterLocation();
            if (filter.isOnCarousel()) {
                FCSCst.FCSLOG.info((Object)(filter.getName() + " location: " + (Object)((Object)filter.getFilterLocation()) + " on " + filter.getSocketName()));
                this.getCarousel().getSocketByName(filter.getSocketName()).putFilterOnSocket(filter);
                continue;
            }
            filter.publishData();
            FCSCst.FCSLOG.info((Object)(filter.getName() + " location: " + (Object)((Object)filter.getFilterLocation())));
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Save filter location in filesystem (in ~ccs/etc/) or Configuration System.")
    default public void saveFilterLocation() {
        try {
            this.getSubsystem().getSubsystemConfigurationEnvironment().saveChangesForCategories(new String[]{FILTER_CONFIG_CATEGORY});
        }
        catch (Exception ex) {
            FCSCst.FCSLOG.error((Object)"Unable to save filter location.", (Throwable)ex);
        }
    }
}

