/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.FCSCst;

public class DigitalSensor
implements UsesSubsystem {
    @ConfigurationParameter(isFinal=true, description="The name of the Digital Input Output device where this sensor is plugged on.")
    private String dioName;
    @ConfigurationParameter(range="0..7", description="The numero of input on DIO device where this sensor is plugged on.")
    private int inputNumero;
    @ConfigurationParameter(range="0..15", description="The numero of the byte where the value of this sensor is stored in.")
    protected int byteNumero;
    protected boolean on = false;

    public DigitalSensor(String dioName, int inputNumero) {
        this.dioName = dioName;
        this.inputNumero = inputNumero;
    }

    public DigitalSensor(String dioName, int inputNumero, int byteNumero) {
        this.dioName = dioName;
        this.inputNumero = inputNumero;
        this.byteNumero = byteNumero;
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public int getInputNumero() {
        return this.inputNumero;
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public boolean isOn() {
        return this.on;
    }

    public synchronized void updateValue(String hex) {
        FCSCst.FCSLOG.finest((Object)(this.getName() + " INPUT NO=" + this.inputNumero));
        int val = Integer.parseInt(hex, 16);
        if (val > 256) {
            throw new IllegalArgumentException("hex ne doit pas etre > 256");
        }
        int mask = (int)Math.pow(2.0, this.inputNumero);
        this.on = (val & mask) == mask;
    }

    public void updateValue(String[] hexaValues) {
        this.updateValue(hexaValues[this.byteNumero]);
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="printValue")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/DIO module=");
        sb.append(this.dioName);
        sb.append("/Input numero=");
        sb.append(String.valueOf(this.inputNumero));
        sb.append("/byteNumero=");
        sb.append(String.valueOf(this.byteNumero));
        sb.append("/value=");
        sb.append(String.valueOf(this.on));
        return sb.toString();
    }
}

