/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;

public class ComplementarySensors
extends Module
implements AlertRaiser {
    private final DigitalSensor sensor;
    private final DigitalSensor sensorC;

    public ComplementarySensors(DigitalSensor sensor, DigitalSensor sensorC) {
        this.sensor = sensor;
        this.sensorC = sensorC;
    }

    public DigitalSensor getSensor() {
        return this.sensor;
    }

    public DigitalSensor getSensorC() {
        return this.sensorC;
    }

    @Command(description="return true if this couple of sensors are in error.")
    public boolean isInError() {
        return this.sensor.isOn() == this.sensorC.isOn();
    }

    @Command(description="return true if sensor's value is 1 and sensorC's value is 0.")
    public boolean isOn() {
        return this.sensor.isOn() && !this.sensorC.isOn();
    }

    public boolean getDigitalValue() {
        return this.sensor.isOn();
    }

    public synchronized void updateValues(String[] hexaValues) {
        this.sensor.updateValue(hexaValues);
        this.sensorC.updateValue(hexaValues);
    }
}

