/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

public class CanOpenTruckMotor
extends SftTruckMotor {
    private final CompactIOModule dio;
    @ConfigurationParameter(range="0..7", description="The numero of the output of DIO where we send a current for the trucks to go to standby")
    private final int outputNumeroToStandby;
    @ConfigurationParameter(range="0..7", description="The numero of the output of DIO where we send a current for the trucks to go to standback")
    private final int outputNumeroToStandback;

    public CanOpenTruckMotor(CompactIOModule dio, int outputNumeroToStandby, int outputNumeroToStandback) {
        this.dio = dio;
        this.outputNumeroToStandby = outputNumeroToStandby;
        this.outputNumeroToStandback = outputNumeroToStandback;
    }

    @Override
    public String moveToStandback() {
        this.setMovingToStandback(true);
        return this.dio.getTcpProxy().writeSDO(this.dio.getNodeID(), 25088, 1, 1, 1);
    }

    @Override
    public String moveToStandby() {
        this.setMovingToStandby(true);
        return this.dio.getTcpProxy().writeSDO(this.dio.getNodeID(), 25088, 1, 1, 2);
    }

    @Override
    public String off() {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return this.dio.getTcpProxy().writeSDO(this.dio.getNodeID(), 25088, 1, 1, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\noutputNumeroToStandby=");
        sb.append(this.outputNumeroToStandby);
        sb.append("\noutputNumeroToStandback=");
        sb.append(this.outputNumeroToStandback);
        return sb.toString();
    }
}

