/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuCarouselClampController
extends SimuEPOSControllerModule {
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private CarouselModule carousel;

    public SimuCarouselClampController(int nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    public void init() {
        this.mode = EPOSEnumerations.EposMode.CURRENT;
    }

    @Override
    public void writeCurrent(int currentValue) {
        CarouselClampModule clamp;
        FCSCst.FCSLOG.debug((Object)(this.getName() + "==========> ACTUATOR ON"));
        if (this.carousel.getSocketAtStandby() == null) {
            throw new RejectedCommandException(this.getName() + " can't writeCurrent to clamp controller when there is no socket at standby position");
        }
        if (this.name.contains("Xminus")) {
            clamp = this.carousel.getSocketAtStandby().getClampXminus();
        } else if (this.name.contains("Xplus")) {
            clamp = this.carousel.getSocketAtStandby().getClampXplus();
        } else {
            throw new RejectedCommandException(this.name + ":couldn't find the clamp to unlock");
        }
        ((SimuCarouselClampLockSensor)clamp.getLockSensor()).simulateClampIsUNLOCKED();
        this.publishData();
    }

    @Override
    public void stopAction() {
        CarouselClampModule clamp;
        FCSCst.FCSLOG.debug((Object)(this.name + "==========> ACTUATOR OFF"));
        if (this.name.contains("Xminus")) {
            clamp = this.carousel.getClampXminus();
        } else if (this.name.contains("Xplus")) {
            clamp = this.carousel.getClampXplus();
        } else {
            throw new FailedCommandException(this.name + ": unable to find the clamp to unlock.");
        }
        ((SimuCarouselClampLockSensor)clamp.getLockSensor()).simulateClampIsLOCKED();
        this.publishData();
    }
}

