/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;

public class CanOpenSensor14bits
extends Sensor14bits
implements HasLifecycle {
    protected CanOpenADC adc;
    @ConfigurationParameter(range="1..25", description="The numero of the input of ADC where this sensor is plugged on.")
    protected int numOfAnalogInput;

    public CanOpenSensor14bits(CanOpenADC adc, int numOfAnalogInput) {
        this.adc = adc;
        this.numOfAnalogInput = numOfAnalogInput;
    }

    @Override
    public int readNewValue() {
        return this.adc.readAnalogInput(this.numOfAnalogInput);
    }

    @Override
    public int updateValue(PDOStorage pdoStorage) {
        this.value = pdoStorage.getVarValue(this.adc.nodeID, this.numOfAnalogInput);
        return this.value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/adcName=");
        sb.append(this.adc.name);
        sb.append("/inputNumero=");
        sb.append(this.numOfAnalogInput);
        return sb.toString();
    }
}

