/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenProxy
extends FcsTcpProxy
implements HardwareController,
ClearAlertHandler,
BridgeToHardware {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;
    @ConfigurationParameter(isFinal=true)
    private String clientName;
    @ConfigurationParameter(range="1000..10000", description="A timeout for the hardware booting process")
    private long hardwareBootTimeout = 1000L;
    protected final Map<Integer, PieceOfHardware> hardwareMapByNodeID = new HashMap<Integer, PieceOfHardware>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, PieceOfHardware> hardwareMapByName = new HashMap<String, PieceOfHardware>();
    private boolean hardwareIDError;
    protected boolean hardwareBootProcessEnded = false;
    protected int bootedDeviceNB;
    private PDOStorage pdoStorage;
    private ScheduledFuture<?> checkDevicesHandle;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    protected final Condition bootingCompleted = this.lock.newCondition();

    public CanOpenProxy(int portNumber, int fieldBusTimeout, String clientName, long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout);
        this.clientName = clientName;
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    public String getMyClientName() {
        return this.clientName;
    }

    public PDOStorage getPdoStorage() {
        return this.pdoStorage;
    }

    @Override
    public void disconnectHardware() {
        this.stopServer();
        this.initialize();
    }

    @Override
    public void connectHardware() {
        this.startServer();
        this.startThreadReader();
    }

    @Override
    public void init() {
        super.init();
        this.initialize();
        for (PieceOfHardware poh : this.hardwareMapByName.values()) {
            this.hardwareMapByNodeID.put(poh.getNodeID(), poh);
        }
        FCSCst.FCSLOG.info((Object)(this.name + ": init MODULE CanOpenProxy."));
        FCSCst.FCSLOG.info((Object)(this.name + ":NUMBER OF CAN OPEN DEVICES EXPECTED =" + this.hardwareMapByName.size()));
        FCSCst.FCSLOG.info((Object)this.toString());
        CanOpenErrorsTable.loadCanOpenErrorTables();
    }

    public void initialize() {
        this.bootedDeviceNB = 0;
        this.hardwareBootProcessEnded = false;
        this.hardwareIDError = false;
        this.hardwareMapByName.values().stream().forEach(poh -> poh.setBooted(false));
        this.pdoStorage = new PDOStorage();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, description="Check if all pieces of hardware are booted with the corect serial number.")
    public void bootProcess() {
        FCSCst.FCSLOG.info((Object)(this.name + ": BEGIN OF BOOT PROCESS"));
        this.initialize();
        this.s.updateAgentState(new Enum[]{FcsEnumerations.FilterState.CAN_DEVICES_BOOTING, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.lock.lock();
        try {
            this.readDevicesInfo(System.currentTimeMillis(), this.hardwareBootTimeout);
            this.waitForEndOfBooting();
        }
        catch (Exception ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " ERROR during booting process", ex);
        }
        finally {
            FCSCst.FCSLOG.debug((Object)(this.getName() + ": finally in bootProcess"));
            this.hardwareBootProcessEnded = true;
            this.bootingCompleted.signalAll();
            this.lock.unlock();
        }
        if (!this.hardwareIDError) {
            FCSCst.FCSLOG.info((Object)(this.name + " ALL HARDWARE is booted"));
            this.s.updateAgentState(new Enum[]{FcsEnumerations.FilterState.HOMING_TO_BE_DONE, FcsEnumerations.FilterReadinessState.READY});
        } else {
            FCSCst.FCSLOG.info((Object)(this.name + " SOME HARDWARE is MISSING"));
        }
        FCSCst.FCSLOG.info((Object)(this.name + " BOOTED HARDWARE=" + this.listBootedNodes()));
        FCSCst.FCSLOG.info((Object)(this.name + ": END OF BOOT PROCESS"));
    }

    public void postStart() {
        FCSCst.FCSLOG.debug((Object)(this.name + ": BEGIN postStart"));
        this.bootProcess();
        FCSCst.FCSLOG.debug((Object)(this.name + ": END postStart"));
        this.publishData();
    }

    private void readDevicesInfo(long beginTime, long timeout) {
        Runnable checkDevices = () -> {
            this.retrieveHardwareInfo();
            this.publishData();
            long duration = System.currentTimeMillis() - beginTime;
            FCSCst.FCSLOG.fine((Object)("duration=" + duration));
            FCSCst.FCSLOG.fine((Object)("bootedDeviceNB=" + this.bootedDeviceNB));
            if (duration > timeout || this.bootedDeviceNB == this.hardwareMapByName.size()) {
                this.hardwareBootProcessEnded = true;
                this.cancelReadDevicesInfo();
            }
        };
        this.checkDevicesHandle = this.scheduler.scheduleAtFixedRate(checkDevices, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void cancelReadDevicesInfo() {
        this.lock.lock();
        try {
            FCSCst.FCSLOG.debug((Object)(this.name + " => stop waiting for devices info."));
            this.bootingCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.checkDevicesHandle.cancel(true);
        FCSCst.FCSLOG.debug((Object)(this.name + " => readDevicesInfo canceled"));
    }

    private void waitForEndOfBooting() {
        while (!this.hardwareBootProcessEnded) {
            try {
                FCSCst.FCSLOG.info((Object)(this.name + " waiting until all pieces of hardware are booted."));
                this.bootingCompleted.await();
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.info((Object)(this.name + ": InterruptedException received=" + ex));
                break;
            }
        }
        FCSCst.FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF BOOTING PROCESS"));
    }

    public void checkStarted() {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN checkStarted"));
        this.bootProcess();
        FCSCst.FCSLOG.info((Object)(this.getName() + " END checkStarted"));
    }

    @Override
    public void shutdownNow() {
        super.shutdownNow();
        this.scheduler.shutdown();
    }

    public String getNodeName(int aNodeID) {
        if (this.hardwareMapByNodeID.get(aNodeID) == null) {
            return "UnknownDevice" + aNodeID;
        }
        return this.hardwareMapByNodeID.get(aNodeID).getName();
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Print the list of CANopen nodes which are booted on the CAN bus. (values are in HEXA)")
    public String listBootedNodes() {
        if (this.bootedDeviceNB == 0) {
            return this.name + ": no booted CANopen devices.";
        }
        StringBuilder sb = new StringBuilder();
        for (PieceOfHardware poh : this.hardwareMapByName.values()) {
            if (!poh.isBooted()) continue;
            sb.append("\n==>");
            sb.append(poh);
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen command to the Can Bus.")
    public String sendCanOpenCommand(String command) {
        if (!this.tcpServerStarted) {
            throw new FcsHardwareException(this.name + ": is not started, can't send CanOpen commands.");
        }
        FcsUtils.checkCommand(command);
        return this.sendCanOpen(command);
    }

    public void checkNodeID(int nodeID) {
        if (!this.hardwareMapByNodeID.containsKey(nodeID)) {
            throw new IllegalArgumentException(nodeID + " is not in the hardware list for tcpProxy " + this.name);
        }
    }

    protected String sendCanOpen(String command) {
        try {
            FCSCst.FCSLOG.debug((Object)(this.name + ":Sending CANopen command : " + command));
            return (String)this.call(this.getMyClientName(), command);
        }
        catch (CWrapperNotConnected ex) {
            throw new FcsHardwareException("CWrapper not connected- check ethernet connections.", (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen writeSDO command to the Can Bus.  \nValues of the argument are to be given in hexadecimal format for: index and subindex\n and in decimal format for size and value.\n size represents the number of bytes on which the value is encoded. See device documentation.")
    public String writeSDO(int nodeID, int index, int subindex, int size, int value) {
        this.checkNodeID(nodeID);
        if (size < 0 || size > 4) {
            throw new IllegalArgumentException("size must be > 0 and < 4");
        }
        String request = FcsUtils.buildWsdoCommand(nodeID, index, subindex, size, value);
        String sdoResponseLine = this.sendCanOpen(request);
        String[] words = sdoResponseLine.split(",");
        int errorCode = Integer.parseInt(words[2], 16);
        if (0 == errorCode) {
            return "OK";
        }
        String msg = this.name + ":wrong writeSDO command : " + sdoResponseLine;
        this.processSDORequestError(request, sdoResponseLine, nodeID, errorCode, AlertState.ALARM);
        throw new SDORequestException(msg);
    }

    public int readSDO(int nodeID, int index, int subindex) {
        String request = FcsUtils.buildRsdoCommand(nodeID, index, subindex);
        String sdoLine = this.sendCanOpen(FcsUtils.buildRsdoCommand(nodeID, index, subindex));
        return Integer.parseInt(this.processResponseToReadSDO(sdoLine, nodeID, request), 16);
    }

    public int readSDOLong(int nodeID, int index, int subindex) {
        String request = FcsUtils.buildRsdoCommand(nodeID, index, subindex);
        String sdoLine = this.sendCanOpen(FcsUtils.buildRsdoCommand(nodeID, index, subindex));
        return new BigInteger(this.processResponseToReadSDO(sdoLine, nodeID, request), 16).intValue();
    }

    public String processResponseToReadSDO(String response, int nodeID, String request) {
        String[] words = response.split(",");
        int responseLength = words.length;
        int errorCode = Integer.parseInt(words[2], 16);
        if (errorCode == 0 && responseLength > 3) {
            return words[3];
        }
        if (errorCode == 0 && responseLength == 3) {
            String msg = this.name + ":readSDO request received a too short response=" + response + " request was" + request;
            String deviceName = this.getNodeName(nodeID);
            this.raiseWarning(deviceName + ":" + FcsEnumerations.FcsAlert.SDO_TOO_SHORT, FcsEnumerations.FcsAlert.SDO_TOO_SHORT.getLongDescription(), msg);
            throw new ShortResponseToSDORequestException(msg);
        }
        if (-1 == errorCode) {
            String msg = this.name + ":wrong readSDO command : " + request + " response:" + response;
            String deviceName = this.getNodeName(nodeID);
            this.raiseAlarm(FcsEnumerations.FcsAlert.SDO_ERROR, msg, deviceName);
            throw new SDORequestException(msg);
        }
        String msg = this.name + ":wrong readSDO command : " + request + " response:" + response;
        this.processSDORequestError(request, response, nodeID, errorCode, AlertState.ALARM);
        throw new SDORequestException(msg);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Send a CANOpen readSDO command to the Can Bus.")
    public String readSDOCommand(int nodeID, int index, int subindex) {
        this.checkNodeID(nodeID);
        return Integer.toHexString(this.readSDO(nodeID, index, subindex));
    }

    public void processSDORequestError(String request, String response, int nodeID, int errorCode, AlertState alertState) {
        String errorName = CanOpenErrorsTable.getCommErrorNameByCode(errorCode);
        String deviceName = this.getNodeName(nodeID);
        String msg = this.name + ": SDO request was going wrong for device: " + deviceName;
        msg = msg + ",request=" + request + ",received response=" + response;
        msg = msg + ",errorCode=" + errorCode + ",errorName=" + errorName;
        if (alertState == AlertState.WARNING) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, msg, deviceName);
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.SDO_ERROR, msg, deviceName);
        }
    }

    @Override
    public PDOStorage readPDOs() {
        try {
            String replyToSync = this.sendCanOpen("sync");
            FCSCst.FCSLOG.finest((Object)(this.name + ": replyToSync=" + replyToSync));
            this.pdoStorage.updatePDOs(replyToSync);
            return this.pdoStorage;
        }
        catch (FcsHardwareException ex) {
            String msg = this.name + ": error in response to a sync command.";
            this.raiseAlarm(FcsEnumerations.FcsAlert.READ_PDO_ERROR, msg, this.name, (Exception)((Object)ex));
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Identification of the hardware : we want to retrieve the information stored in the hardware of the CANopen devices")
    public void retrieveHardwareInfo() {
        FCSCst.FCSLOG.info((Object)(this.getName() + ":Identification of the hardware"));
        this.hardwareMapByName.values().stream().filter(poh -> !poh.isBooted()).forEach(poh -> this.updateDeviceInfo((PieceOfHardware)poh));
        this.publishData();
    }

    private void updateDeviceInfo(PieceOfHardware poh) {
        int nodeID = poh.getNodeID();
        String commandInfo = "info," + Integer.toHexString(nodeID);
        try {
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":Sending to can open command :" + commandInfo));
            String result = this.sendCanOpen(commandInfo);
            this.processInfoMessage(poh, result);
        }
        catch (CanOpenCallTimeoutException ex) {
            if (!"tmpSensorsDevice".equals(poh.getName())) {
                this.hardwareIDError = true;
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_MISSING, " no response to command : " + commandInfo, poh.getName(), (Exception)((Object)ex));
            } else {
                this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_MISSING, " no response to command : " + commandInfo, poh.getName(), (Exception)((Object)ex));
            }
        }
        catch (FcsHardwareException ex) {
            this.hardwareIDError = true;
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " Error in boot process for device.", poh.getName(), (Exception)((Object)ex));
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all CANopen devices are booted and identified.Identified means that the serial numbers match the CANopen nodeID which reside inconfiguration.")
    public boolean allDevicesBooted() {
        boolean bootedDevicesNumberOK = this.bootedDeviceNB == this.hardwareMapByNodeID.size();
        FCSCst.FCSLOG.info((Object)(this.name + ":hardwareBootProcessEnded=" + this.hardwareBootProcessEnded));
        FCSCst.FCSLOG.info((Object)(this.name + ":canOpenNodeNumbersOK=" + bootedDevicesNumberOK));
        FCSCst.FCSLOG.info((Object)(this.name + ":hardwareIDError=" + this.hardwareIDError));
        return this.hardwareBootProcessEnded && bootedDevicesNumberOK && !this.hardwareIDError;
    }

    @Override
    void processBootMessage(int nodeID) {
        if (this.hardwareMapByNodeID.containsKey(nodeID)) {
            PieceOfHardware poh = this.hardwareMapByNodeID.get(nodeID);
            if (poh.isBooted()) {
                this.checkResetNode(nodeID, poh.getName());
            }
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.UNSYNC_BOOT, nodeID + ":UNKNOWN device. This device is not in the harware list.");
        }
    }

    private void checkResetNode(int nodeID, String deviceName) {
        if (this.hardwareBootProcessEnded) {
            String cause = this.getName() + " received an unsynchronous boot message for node ID = " + nodeID + " Has the device been reset or powered on ?";
            this.raiseWarning(FcsEnumerations.FcsAlert.UNSYNC_BOOT, deviceName, cause);
        }
    }

    @Override
    public void processEmcyMessage(String message) {
        String[] words = message.split(",");
        int nodeID = Integer.parseInt(words[1], 16);
        int deviceErrorCode = Integer.parseInt(words[2], 16);
        String deviceErrorName = CanOpenErrorsTable.getDeviceErrorNameByCode(deviceErrorCode);
        int errReg = Integer.parseInt(words[3], 16);
        String errorRegisterName = CanOpenErrorsTable.getErrorRegisterNameByCode(errReg);
        String deviceName = this.getNodeName(nodeID);
        EmergencyMessage emcyMsg = new EmergencyMessage(nodeID, deviceName, deviceErrorCode, deviceErrorName, errReg, errorRegisterName);
        PieceOfHardware poh = this.hardwareMapByNodeID.get(nodeID);
        if (poh != null) {
            this.s.getScheduler().schedule(() -> poh.onEmergencyMessage(emcyMsg), 0L, TimeUnit.SECONDS);
        }
        FCSCst.FCSLOG.warning((Object)(this.name + " received EMERGENCY message=" + message + " for nodeID=" + Integer.toHexString(nodeID)));
        if (errReg == 0 || 32 == nodeID || 34 == nodeID) {
            this.raiseWarning(FcsEnumerations.FcsAlert.EMCY, emcyMsg.toString(), deviceName);
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.EMCY, emcyMsg.toString(), deviceName);
        }
    }

    void processInfoMessage(PieceOfHardware poh, String message) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":Received on socket command = " + message));
        String[] words = message.split(",");
        int nodeID = Integer.parseInt(words[1], 16);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":checking serial number for nodeID " + Integer.toHexString(nodeID)));
        String type = words[2];
        String vendor = words[3];
        String productCode = words[4];
        String revision = words[5];
        String serialNB = words[6];
        FCSCst.FCSLOG.info((Object)(this.name + "/" + poh.getName() + " informations read on device: type=" + type + " vendor=" + vendor + " product code=" + productCode + " revision=" + revision + " serialNB" + serialNB));
        if (poh.getSerialNB().equals(serialNB)) {
            poh.setBooted(true);
            ++this.bootedDeviceNB;
        } else {
            this.hardwareIDError = true;
            this.raiseAlarm(FcsEnumerations.FcsAlert.BAD_SERIAL_NB, " serial number read on device=" + serialNB + " ==>serial number expected=" + poh.getSerialNB() + " ==>device configuration=" + poh, poh.getName());
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware expected in this subsystem.")
    public String printHardwareList() {
        return this.hardwareMapByName.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware with the initialization state.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.name + " CANopen devices : {");
        for (PieceOfHardware poh : this.hardwareMapByNodeID.values()) {
            sb.append(poh.printState());
            sb.append(";\n");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return an Array containing hardware names handled by this component.")
    public List<String> listHardwareNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (PieceOfHardware pieceOfHardware : this.hardwareMapByName.values()) {
            res.add(pieceOfHardware.getName());
        }
        return res;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        switch (alert.getAlertId()) {
            case "FCS001": {
                if (this.clientContext.socket.isConnected() && !this.clientContext.socket.isClosed()) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            case "FCS002": {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish booting information for all CANopen devices.")
    public void publishData() {
        FCSCst.FCSLOG.info((Object)(this.getName() + " is publishing:" + this.bootedDeviceNB));
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)Integer.valueOf(this.bootedDeviceNB)));
        for (PieceOfHardware device : this.hardwareMapByName.values()) {
            device.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed format of PDOStorage.")
    public String printPDOStorage() {
        return this.pdoStorage.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/clientName=");
        sb.append(this.clientName);
        sb.append("/hardwareBootTimeout=");
        sb.append(this.hardwareBootTimeout);
        return sb.toString();
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.isReady(this.getMyClientName());
    }

    @Override
    public boolean isRealHardware() {
        return true;
    }
}

