/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;

public class CanOpenADC
extends CanOpenDevice
implements ADCInterface {
    public static final double adcVoltsPerBit = 0.3125;
    public static final double waterFreezeTemp = 273.15;
    @ConfigurationParameter
    protected int transmissionType;
    long pdoVal = 0L;
    private int[] inputs = new int[8];

    public CanOpenADC(int nodeID, String serialNB, int transmissionType) {
        super(nodeID, serialNB);
        this.transmissionType = transmissionType;
    }

    @Override
    @Command
    public int readAnalogInput(int inputNB) {
        if (!this.tcpProxy.isCWrapperConnected()) {
            throw new HardwareNotDetectedException(this.name + ": hardware not connected.");
        }
        if (this.isBooted()) {
            if (inputNB < 1 || inputNB > 8) {
                throw new IllegalArgumentException("CAN-CBX-AI814 : input has to be 1..8");
            }
            return this.tcpProxy.readSDO(this.nodeID, 25601, inputNB);
        }
        String message = String.format("Module %s / nodeID=%s is UNREACHABLE", this.getName(), this.nodeID);
        FCSCst.FCSLOG.error((Object)message);
        throw new HardwareNotDetectedException("CanOpenADC MISSING", this.getName(), this.nodeID, this.serialNB);
    }

    @Override
    public double readVoltage(int inputNB) {
        return (double)this.readAnalogInput(inputNB) * 0.3125;
    }

    @Override
    @Command
    public void initializeAndCheckHardware() {
        this.writeTransmissionTypeToDevice();
        this.initialized = true;
    }

    @Command
    protected String writeTransmissionTypeToDevice() {
        this.tcpProxy.writeSDO(this.nodeID, 6145, 2, 1, this.transmissionType);
        this.tcpProxy.writeSDO(this.nodeID, 6146, 2, 1, this.transmissionType);
        return String.format("Transmission type of device %s is now %s", this.getName(), this.transmissionType);
    }

    protected void updateWithPDO(int cob_id, long pdoVal) {
        int raw_cobId = cob_id - this.nodeID;
        if (raw_cobId == 640) {
            this.inputs[3] = (int)(pdoVal >> 48);
            this.inputs[2] = (int)(pdoVal >> 32 & 0xFFFFL);
            this.inputs[1] = (int)(pdoVal >> 16 & 0xFFFFL);
            this.inputs[0] = (int)(pdoVal & 0xFFFFL);
        } else if (raw_cobId == 896) {
            this.inputs[7] = (int)pdoVal >> 48;
            this.inputs[6] = (int)pdoVal >> 32 & 0xFFFF;
            this.inputs[5] = (int)pdoVal >> 16 & 0xFFFF;
            this.inputs[4] = (int)pdoVal & 0xFFFF;
        } else {
            FCSCst.FCSLOG.warning((Object)("wrong cobid received : " + raw_cobId));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="send a sync command to CANbus, process response and update pdoVal.")
    public void updatePDO() {
        this.pdoVal = this.extractMyPDO(this.tcpProxy.sendCanOpen("sync"));
    }

    protected long extractMyPDO(String replyToSync) {
        String[] words = replyToSync.split(",");
        if (words[1].startsWith("PDO2") && words[0].split("=").length > 0) {
            String pdoValStr = words[1].split("=")[1];
            return Long.valueOf(pdoValStr, 16);
        }
        throw new IllegalArgumentException(this.name + " " + replyToSync + ": bad response to sync command. ");
    }
}

