/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;

public class MainModule
implements AlertRaiser,
SignalHandler,
HasLifecycle {
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FilterManager filterManager;
    protected BridgeToHardware bridge;
    protected AtomicBoolean haltRequired = new AtomicBoolean(false);
    protected AtomicBoolean stopRequired = new AtomicBoolean(false);

    public MainModule(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    public boolean isHaltRequired() {
        return this.haltRequired.get();
    }

    public boolean isStopRequired() {
        return this.stopRequired.get();
    }

    public void init() {
        String msg = this.controlRealHardware() ? "Real Hardware" : "Simulation";
        FCSCst.FCSLOG.info((Object)(this.name + "==>" + msg));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if all hardware is booted with the correct serial number.")
    public boolean allDevicesBooted() {
        return this.bridge.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if this main module controls real hardware.")
    public boolean controlRealHardware() {
        return this.bridge.isRealHardware();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns the list of CANopen hardware managed by this subsystem.")
    public List<String> listHardwareNames() {
        return this.bridge.listHardwareNames();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the list of LOADER CANopen hardware managed by this subsystem.")
    public List<String> listLoaderHardwareNames() {
        return Collections.emptyList();
    }

    @Command(type=Command.CommandType.QUERY, description="Return the list of names of filters  that this subsystem manages.", level=1, alias="listFilterNames")
    public List<String> getFilterNames() {
        return this.filterManager == null ? Collections.emptyList() : this.filterManager.getFilterNamesSortedByFilterID();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update state in reading sensors.")
    public void updateStateWithSensors() {
        this.bridge.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readiness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.allDevicesBooted() && !this.getSubsystem().isInState((Enum)AlertState.ALARM)) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HARDWARE_READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }

    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                FCSCst.FCSLOG.debug((Object)"HALT required");
                this.haltRequired.set(true);
                break;
            }
            case STOP: {
                FCSCst.FCSLOG.debug((Object)"STOP required");
                this.stopRequired.set(true);
                break;
            }
            case RE_START: {
                this.haltRequired.set(false);
                this.stopRequired.set(false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return TreeWalkerDiag.GO;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Publish Data to populate GUI.")
    public void publishData() {
        this.bridge.publishData();
    }
}

