###########################################################################
#Script to test the simulated hardware of carousel in standalone mode.
#This test is a part of integration tests.
###########################################################################
#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from java.lang import RuntimeException
from org.lsst.ccs.command import CommandInvocationException

print "Loading module", __name__

#
CCS.setThrowExceptions(True)

carouselStandalone = CCS.attachSubsystem("carousel-standalone");
print "Connected to carousel in STANDALONE mode.", carouselStandalone

###Filters###
filterMng = CCS.attachSubsystem("carousel-standalone/filterManager")
result = filterMng.synchCommandLine(5, "toString")
print "### Filter Manager:", result.getResult()
print "### end Filter Manager"
###end Filters###

#getting timeouts
carouselConfigFuture = carouselStandalone.asynchCommandLine("getConfigurationInfo")
print "getting carousel subsystem configuration"
carouselConfig = carouselConfigFuture.get()

print "Carousel config =", carouselConfig.toString()

CCS.setThrowExceptions(False)

#Handle the thrown exceptions                                                                                                 
print "read sensors and update state "
result = carouselStandalone.synchCommandLine(3000, "updateStateWithSensors")

if isinstance(result.getResult(), CommandInvocationException):
     raise Exception(result.getResult())

#These tests are done in carouselTest.java
#Test that clamps are LOCKED
#for i in range(5):
#    print "socket", i
#    print "clamp=","clampXminus"+str(i)
#    #result = carouselStandalone.synchCommandLine(3000, "clampXminus"+str(i)+"/isLocked")

#print "END LOOP"

#print "Carousel Subsystem state has been updated"
CCS.setThrowExceptions(True)

########################################################

