/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenProxyTest
extends CcsTestCaseTemplate {
    private static Subsystem subs;
    private static CanOpenProxy tcpProxy;
    private static final String deviceName1 = "device1";
    private static final String deviceName2 = "device2";
    private static final String deviceName3 = "device3";
    private static final int nodeID1 = 586;
    private static final int nodeID2 = 12106;
    private static final int nodeID3 = 3;
    private static final String serial1 = "8XFFV678";
    private static final String serial2 = "99xfr56A";
    private static final String serial3 = "033fzbgt4";
    private static final String infoMessage3;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("        TESTS OF CanOpenProxy");
        System.out.println("***************************************");
        subs = BootUtils.getSubsystemFromFile((String)"testCanOpenProxy");
        subs.startAgent();
        ComponentLookup lookup = subs.getComponentLookup();
        tcpProxy = (CanOpenProxy)lookup.getComponentByName("main");
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("********* end of CanOpenProxy tests *************");
        subs.shutdown();
    }

    @Before
    public void setUp() throws InterruptedException {
        Utils.printJoliSetUp("CanOpenProxyTest");
        subs.getAlertService().clearAllAlerts();
        Assert.assertTrue((String)"subs is in state NOMINAL", (boolean)subs.isInState((Enum)AlertState.NOMINAL));
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSetHardwareList() {
        System.out.println("#setHardwareList");
        Assert.assertEquals((String)"There is 3 devices in hardwareList.", (long)3L, (long)CanOpenProxyTest.tcpProxy.hardwareMapByNodeID.size());
    }

    @Test
    public void testGetMyClientName() {
        System.out.println("#getMyClientName");
        String expResult = "testFCS";
        String result = tcpProxy.getMyClientName();
        Assert.assertEquals((String)"Client name = testFCS", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetPdoStorage() {
        System.out.println("#getPdoStorage");
        String expResult = "PDO STORAGE:(SIZE=0){}";
        String result = tcpProxy.getPdoStorage().toString();
        Assert.assertEquals((String)"PDO Storage should be empty.", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetNodeName() {
        System.out.println("#getNodeName");
        String expResult = deviceName1;
        String result = tcpProxy.getNodeName(586);
        Assert.assertEquals((String)"Name of device1 isdevice1", (Object)expResult, (Object)result);
        expResult = deviceName2;
        result = tcpProxy.getNodeName(12106);
        Assert.assertEquals((String)"Name of device2 isdevice2", (Object)expResult, (Object)result);
        int fakeNodeID = 65535;
        result = tcpProxy.getNodeName(fakeNodeID);
        System.out.println("Result=" + result);
        expResult = "UnknownDevice" + fakeNodeID;
        Assert.assertEquals((String)(fakeNodeID + "is unbooted."), (Object)expResult, (Object)result);
    }

    @Test
    public void testIsHardwareReady() {
        System.out.println("#isHardwareReady");
        Assert.assertTrue((String)"isHardwareReady returns false because the tcp server is not started", (boolean)tcpProxy.allDevicesBooted());
    }

    @Test
    public void testProcessBootMessage() {
        System.out.println("#processBootMessage");
        PieceOfHardware poh1 = (PieceOfHardware)CanOpenProxyTest.tcpProxy.hardwareMapByNodeID.get(586);
        Assert.assertTrue((String)"586 is booted", (boolean)poh1.isBooted());
        tcpProxy.processBootMessage(586);
        System.out.println("subsystem state=" + subs.getState());
        Assert.assertTrue((String)("Received a boot message for node " + Integer.toHexString(586) + "so subsystem should be WARNING"), (boolean)subs.isInState((Enum)AlertState.WARNING));
    }

    @Test
    public void testProcessEmcyMessage() {
        System.out.println("#processEmcyMessage");
        try {
            tcpProxy.processEmcyMessage("emcy," + Integer.toHexString(586) + ",00,00");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.toString(), (boolean)(ex instanceof NullPointerException));
        }
        try {
            tcpProxy.processEmcyMessage("emcy,001a,00,00");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.toString(), (boolean)(ex instanceof NullPointerException));
        }
    }

    @Test
    public void testProcessInfoMessage() {
        System.out.println("#processInfoMessage");
        tcpProxy.processBootMessage(3);
        PieceOfHardware poh3 = (PieceOfHardware)CanOpenProxyTest.tcpProxy.hardwareMapByNodeID.get(3);
        tcpProxy.processInfoMessage(poh3, infoMessage3);
        Assert.assertEquals((String)"Serial number of node3 should now be 033fzbgt4", (Object)poh3.getSerialNB(), (Object)serial3);
    }

    @Test
    public void testProcessUnknownCommand() {
        System.out.println("#processUnknownCommand");
        String message = "Unknown,COUCOU";
        try {
            tcpProxy.processUnknownCommand(message);
            System.out.println("AlertState=" + subs.getState());
            Assert.assertTrue((String)"s should be in AlertState.WARNING", (boolean)subs.isInState((Enum)AlertState.WARNING));
        }
        catch (NullPointerException ex) {
            System.out.println(ex);
            System.out.println("When an unknown message is received from the CANbus, an ALARM of type WARNING is raised.A NullPointerException is raised because getSubsystem() is null.");
        }
    }

    @Test
    public void testProcessResponseToReadSDO() {
        System.out.println("#processResponseToReadSDO");
        String response = "rsdo,3a,00,ff";
        int nodeID = 58;
        String request = "rsdo,3a,1003,01";
        String expResult = "ff";
        try {
            String result = tcpProxy.processResponseToReadSDO(response, nodeID, request);
            Assert.assertEquals((String)("response to" + request + " is " + expResult), (Object)expResult, (Object)result);
        }
        catch (Exception ex) {
            System.out.println("Should not raised an Exception:" + ex);
        }
        response = "rsdo,3a,06010000,ff";
        nodeID = 58;
        request = "rsdo,3a,1003,01";
        expResult = "ff";
        try {
            tcpProxy.processResponseToReadSDO(response, nodeID, request);
            Assert.fail((String)("response to" + request + " is not" + expResult));
        }
        catch (NullPointerException | SDORequestException ex) {
            System.out.println("response to" + request + " is not" + expResult + " should raised an Exception:" + ex);
        }
        catch (ShortResponseToSDORequestException ex) {
            System.out.println("Should raised an Exception of type SDORequestException:" + (Object)((Object)ex));
        }
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        String expResult = "main/port=53000/clientName=testFCS/hardwareBootTimeout=10000";
        String result = tcpProxy.toString();
        Assert.assertEquals((String)"toString method should returns:main/port=53000/clientName=testFCS/hardwareBootTimeout=10000", (Object)expResult, (Object)result);
    }

    static {
        infoMessage3 = "info," + Integer.toHexString(3) + ",type, vendor, productCode, revision," + serial3;
    }
}

