/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;

public class RedondantSensorsTest {
    static RedondantSensors sensors;
    static DigitalSensor sensor;
    static DigitalSensor sensorR;
    static int[] hexaValues;

    @BeforeClass
    public static void setUpClass() {
        int inputNumero = 0;
        int byteNumero = 0;
        int inputNumeroR = 1;
        int byteNumeroR = 0;
        sensor = new DigitalSensor("gateway", inputNumero, byteNumero);
        sensorR = new DigitalSensor("gateway", inputNumeroR, byteNumeroR);
        sensors = new RedondantSensors(sensor, sensorR);
        RedondantSensorsTest.hexaValues[0] = 1;
        sensors.updateValue(hexaValues);
        System.out.println("sensor=" + sensor.toString());
        System.out.println("sensorR=" + sensorR.toString());
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private void printSensors() {
        System.out.println("sensor=" + sensor.toString());
        System.out.println("sensorR=" + sensorR.toString());
    }

    @Test
    public void testIsInError() {
        System.out.println("*****isInError");
        RedondantSensorsTest.hexaValues[0] = 0;
        sensors.updateValue(hexaValues);
        this.printSensors();
        Assert.assertFalse((String)"Sensors are in error", (boolean)sensors.isInError());
        RedondantSensorsTest.hexaValues[0] = 1;
        sensors.updateValue(hexaValues);
        this.printSensors();
        Assert.assertTrue((String)"Sensors are NOT in error", (boolean)sensors.isInError());
    }

    @Test
    public void testIsOn() {
        System.out.println("****isOn");
        RedondantSensorsTest.hexaValues[0] = 3;
        sensors.updateValue(hexaValues);
        this.printSensors();
        Assert.assertTrue((String)"sensors are ON", (boolean)sensors.isOn());
        RedondantSensorsTest.hexaValues[0] = 0;
        sensors.updateValue(hexaValues);
        this.printSensors();
        Assert.assertFalse((String)"sensors are NOT ON", (boolean)sensors.isOn());
    }

    @Test
    public void testUpdateValues() {
        System.out.println("*****updateValues");
        RedondantSensorsTest.hexaValues[0] = 3;
        sensors.updateValue(hexaValues);
        this.printSensors();
        Assert.assertTrue((String)"sensors are ON", (boolean)sensors.isOn());
    }

    static {
        hexaValues = new int[1];
    }
}

