/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.LoaderMainModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderStandalonePlutoGateway;

public class LoaderClampModuleTest
extends CcsTestCaseTemplate {
    private static ComponentLookup lookup;
    private static Subsystem loaderSubsystem;
    private static LoaderMainModule main;
    private static LoaderClampModule clamp;
    private static LoaderModule loader;
    private static SimuLoaderClampController clampController;
    private static SimuLoaderStandalonePlutoGateway gateway;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("******************************************");
        System.out.println("TESTS OF LOADER CLAMP IN STANDALONE MODE");
        System.out.println("******************************************");
        CCS.initializeScriptingEnvironment();
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"loader__simulation");
        loaderSubsystem.start();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = loaderSubsystem.getComponentLookup();
        main = (LoaderMainModule)lookup.getComponentByName("main");
        clamp = (LoaderClampModule)lookup.getComponentByName("clamp");
        clampController = (SimuLoaderClampController)lookup.getComponentByName("hooksController");
        loader = (LoaderModule)lookup.getComponentByName("loader");
        gateway = (SimuLoaderStandalonePlutoGateway)lookup.getComponentByName("loaderPlutoGateway");
    }

    @AfterClass
    public static void after() throws Exception {
        loaderSubsystem.shutdown();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() {
        Utils.printJoliSetUp("LoaderClampModuleTest");
        gateway.simulateFilterIsOnLoader();
        gateway.simulateLoaderClampIsClamped();
        gateway.simulateLoaderIsConnectedOnCamera();
        gateway.simulateLoaderCarrierIsAtStorage();
        gateway.simulateAutochangerIsNotHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Loader Clamp is clamped.", (boolean)clamp.isClamped());
    }

    @After
    public void tearDown() {
        loaderSubsystem.clearAllAlerts();
    }

    @Test
    public void testGetControllerName() {
        System.out.println("### getControllerName");
        String ctlrName = clamp.getControllerName();
        Assert.assertTrue((String)("Clamp controller name should contains String clamp " + ctlrName), (boolean)ctlrName.contains("hook"));
    }

    @Test
    public void testIsInError() {
        System.out.println("isInError");
        gateway.simulateClampIsInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"loader clamp is in error", (boolean)clamp.isInError());
    }

    public void testCheckHardwareStateAndDoHomingIfPossible() {
        System.out.println("### checkHardwareStateAndDoHomingIfPossible");
        clamp.checkHardwareStateAndDoHomingIfPossible();
        Assert.assertFalse((String)"homing is not done because clamp is not empty", (boolean)clamp.isHomingDone());
    }

    @Test
    public void testOpen() {
        System.out.println("### open");
        try {
            clamp.open();
            Assert.fail((String)"Can't open clamp because carrier is not at HANDOFF position.");
        }
        catch (Exception ex) {
            System.out.println("Can't open clamp because carrier is not at HANDOFF. Exception raised: " + ex);
        }
        gateway.simulateLoaderCarrierIsAtHandoff();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"Carrier is at HANDOFF.", (boolean)loader.isAtHandoff());
        try {
            clamp.open();
            Assert.fail((String)"Can't open clamp because clamp is CLAMPED.");
        }
        catch (Exception ex) {
            System.out.println("Can't open clamp because it's CLAMPED. Exception raised: " + ex);
        }
        gateway.simulateLoaderClampIsClosed();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"Loader Clamp is closed.", (boolean)clamp.isClosed());
        try {
            clamp.open();
            Assert.fail((String)"Can't open clamp because autochanger is not holding it.");
        }
        catch (Exception ex) {
            System.out.println("Can't open clamp because autochanger is not holding it. Exception raised: " + ex);
        }
        gateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"autochanger is now holding filter", (boolean)loader.isAutochangerHoldingFilter());
        clamp.open();
        Assert.assertTrue((String)"Loader Clamp is now opened.", (boolean)clamp.isOpened());
        Assert.assertTrue((String)"Clamp homing should have been done.", (boolean)clamp.isHomingDone());
        clamp.open();
        Assert.assertTrue((String)"Loader Clamp is still opened.", (boolean)clamp.isOpened());
    }

    @Test
    public void testClose() {
        System.out.println("### close");
        try {
            clamp.close();
            Assert.fail((String)"can't close because clamp has to be OPENED before a close action");
        }
        catch (Exception ex) {
            System.out.println("An exception was raised: " + ex);
        }
        gateway.simulateLoaderClampIsOpened();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"Loader Clamp is now opened.", (boolean)clamp.isOpened());
        clamp.close();
        Assert.assertTrue((String)"Loader Clamp is now closed.", (boolean)clamp.isClosed());
        clamp.close();
        Assert.assertTrue((String)"Loader Clamp is still closed.", (boolean)clamp.isClosed());
    }

    @Test
    public void testClamp() {
        System.out.println("clamp");
        clamp.clamp();
        Assert.assertTrue((String)"Loader Clamp is now clamped.", (boolean)clamp.isClamped());
    }

    @Test
    public void testUnclamp() {
        System.out.println("### unclamp");
        try {
            clamp.unclamp();
            Assert.fail((String)"should raise an Exception because carrier is loaded with a filter but not at handoff position - can't unclamp");
        }
        catch (Exception ex) {
            System.out.println("Exception raised because Autochanger is not at HANDOFF : " + ex);
        }
        Assert.assertTrue((String)"Loader Clamp is clamped.", (boolean)clamp.isClamped());
        gateway.simulateLoaderCarrierIsAtHandoff();
        gateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        try {
            clamp.unclamp();
        }
        catch (Exception ex) {
            System.out.println("Exception raised because Autochanger is holding filter, can't unclamp.: " + ex);
        }
        Assert.assertTrue((String)"Loader Clamp is clamped.", (boolean)clamp.isClamped());
        gateway.simulateAutochangerIsNotHoldingFilter();
        main.updateStateWithSensors();
        clamp.unclamp();
        Assert.assertEquals((String)"Clamp Lock Status is CLOSED", (Object)FcsEnumerations.LockStatus.CLOSED, (Object)clamp.getLockStatus());
        Assert.assertTrue((String)"Loader Clamp is now closed.", (boolean)clamp.isClosed());
        clamp.unclamp();
        Assert.assertEquals((String)"Clamp Lock Status is CLOSED", (Object)FcsEnumerations.LockStatus.CLOSED, (Object)clamp.getLockStatus());
        Assert.assertTrue((String)"Loader Clamp is now closed.", (boolean)clamp.isClosed());
    }

    static {
        loaderSubsystem = null;
    }
}

