/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;

public class FilterTest
extends CcsTestCaseTemplate {
    private static Filter filterU;
    private static Filter filterR;
    private static Filter filterG;
    private static final String socketName1 = "socket1";

    @BeforeClass
    public static void setUpClass() {
        System.out.println("***************************************");
        System.out.println("TESTS OF Filter");
        System.out.println("***************************************");
        String name = "filterU";
        int filterID = 1;
        double weight = 45.55;
        filterU = new Filter(filterID, weight, socketName1);
        filterU.initializeFilterLocation();
        Assert.assertTrue((String)"filterU is on Carousel", (boolean)filterU.isOnCarousel());
        name = "filterR";
        filterID = 3;
        weight = 55.0;
        filterR = new Filter(filterID, weight, "");
        filterR.initializeFilterLocation();
        Assert.assertTrue((String)"filterR location is Unknown", (boolean)filterR.isUnknown());
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of Filter tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        filterU.setSocketName(socketName1);
        filterR.setSocketName("");
    }

    @Test
    public void testIsOnCarousel() {
        System.out.println("isOnCarousel");
        Assert.assertTrue((String)"filterU is on Carousel", (boolean)filterU.isOnCarousel());
        Assert.assertFalse((String)"filterR is not on Carousel", (boolean)filterR.isOnCarousel());
    }

    @Test
    public void testIsOnAutoChanger() {
        System.out.println("isOnAutoChanger");
        Assert.assertFalse((String)"filterU is not on Autochanger", (boolean)filterU.isOnAutoChanger());
        Assert.assertFalse((String)"filterR is not on Autochanger", (boolean)filterU.isOnAutoChanger());
        filterG = new Filter(2, 33.0, "AC");
        filterG.initializeFilterLocation();
        Assert.assertTrue((String)"filterG is on AUTOCHANGER", (boolean)filterG.isOnAutoChanger());
    }

    @Test
    public void testIsOut() {
        System.out.println("isOut");
        Assert.assertFalse((String)"filterR is Unknown", (boolean)filterR.isOut());
    }

    @Test
    public void testIsUnknown() {
        System.out.println("isUnknown");
        Assert.assertFalse((String)"filterU location is on Carousel", (boolean)filterU.isUnknown());
        Assert.assertTrue((String)"filterR location is Unknown", (boolean)filterR.isUnknown());
    }

    @Test
    public void testGetFilterLocation() {
        System.out.println("getFilterLocation");
        FcsEnumerations.FilterLocation expResult = FcsEnumerations.FilterLocation.CAROUSEL;
        FcsEnumerations.FilterLocation result = filterU.getFilterLocation();
        Assert.assertEquals((String)"filterU location is CAROUSEL", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetFilterID() {
        System.out.println("getFilterID");
        Integer expResult = 1;
        Integer result = filterU.getFilterID();
        Assert.assertEquals((String)"filterU id is 1", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetWeight() {
        System.out.println("getWeight");
        double expResult = 45.55;
        double result = filterU.getWeight();
        Assert.assertEquals((String)"filterU weight is 45.55", (double)expResult, (double)result, (double)0.0);
    }

    @Test
    public void testGetSocketName() {
        System.out.println("getSocketName");
        String expResult = socketName1;
        String result = filterU.getSocketName();
        Assert.assertEquals((String)"Socket Name for filterU is:socket1", (Object)expResult, (Object)result);
    }

    @Test
    public void testSetSocketName() {
        System.out.println("setSocketName");
        filterU.setSocketName("");
        boolean result = filterU.getSocketName().isEmpty();
        Assert.assertTrue((String)"filerU socket name is now empty", (boolean)result);
        String socketName = "socket5";
        try {
            filterR.setSocketName(socketName);
            Assert.assertEquals((String)"socketName for filterR is socket5", (Object)socketName, (Object)filterR.getSocketName());
        }
        catch (IllegalArgumentException ex) {
            System.out.println("null socket name:" + ex);
            Assert.fail((String)("valid socket name - should not raise an IllegalArgumentException " + ex));
        }
    }
}

