package testbenchCarousel

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.description.groovy.CCSBuilder


import static org.lsst.gruth.jutils.MapArgs.*

CCSBuilder builder = ["testbenchCarousel"]

builder.
        main ( org.lsst.ccs.subsystems.fcs.testbench.CarouselTestbenchMainModule,
                argMap( ref("bridge"),
                        ))
                 


            //begin description of Main submodules
            {       

                // Bridge
                bridge (BridgeToCanOpenHardware,
                        argMap(
                            ref("tcpProxy"),
                            //ref("hyttc580"),
                            ref("clampXminusController"),
                            //ref("clampXplusController"),
                            ref("carouselController"),
                            ref("ai814"),
                            ))

                {//begin description of bridge0's children          

                        // tcp Proxy
                        tcpProxy (CanOpenProxy,
                                argMap(
                                    a("portNumber", 50000),
                                    a("fieldBusTimeout", 2000),
                                    a("myClientName","TestBench"),
                                    a("hardwareBootTimeout",1000),
                                    ))
                                
                        // can open devices for changer devices (autochanger and carousel)
//                        hyttc580 (CanOpenDevice, 
//                                argMap(
//                                    a("nodeID","69"),
//                                    a("serialNB","44110125008180")))
                        clampXminusController (CanOpenDevice, 
                                argMap(
                                    a("nodeID","11"),
                                    a("serialNB","44110125008180")))
                            
                        carouselController (CanOpenDevice, 
                                argMap(
                                    a("nodeID","C"),
                                    a("serialNB","44110125008180")))
                            
                        // can open devices to read brakes sensors and temperatures
                        ai814 (CanOpenADC,
                                argMap(
                                    a("nodeID","14"),
                                    a("serialNB","c7yyyyyy"),
                                    a("transmissionType","1")))

                            
                }//end description of bridge0's children
            }//end of description of Main Module
