
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

/**
 * This class is for the Single Filter Test carousel. 
 * The carousel in Single Filter Test has only one socket and doesn't rotate.
 *
 * @author virieux
 */
public class SftCarouselModule extends CarouselModule {
    
    @Override
    public CarouselSocket getSocketAtStandby() {
        return getSocketByName("socket1");
    }

    @Override
    public int getPosition() {
        return 0;
    }
    
    /**
     * Executed during Initialization phase by the framework.
     */
    @Override
    public void postStart() {
        if (this.ai814.isBooted()) {
            this.ai814.initializeAndCheckHardware();

        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "ai814 not booted", ai814.getName());
        }
    }

    @Override
    public boolean isRotating() {
        return false;
    }

    /**
     * Carousel can't rotate in single-filter-test
     * @param angle
     * @return 
     */
    public String rotate(float angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }
}
