/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This represents the motor that moves an autochanger truck along its rail in
 * the single-filter-test test bench.
 *
 * @author virieux
 */
public class CanOpenTruckMotor extends SftTruckMotor {

    /**
     * The Digital Input-output which controls the motor.
     */
    private final CompactIOModule dio;

    /**
     * Number of the output on the DIO8 where the motor is plugged
     * Used only to be printed.
     */
    @ConfigurationParameter(range="0..7",
            description="The numero of the output of DIO where we send a current for the trucks to go to standby")
    private final int outputNumeroToStandby;
    
    /**
     * Number of the output on the DIO8 where the motor is plugged
     * Used only to be printed.
     */
    @ConfigurationParameter(range="0..7",
            description="The numero of the output of DIO where we send a current for the trucks to go to standback")
    private final int outputNumeroToStandback;
    
    /**
     * Creates a CanOpenTruckMotor with a tickMillis value.
     * 
     * @param dio
     * @param outputNumeroToStandby
     * @param outputNumeroToStandback 
     */
    public CanOpenTruckMotor(
            CompactIOModule dio, int outputNumeroToStandby, int outputNumeroToStandback) {
        this.dio = dio;
        this.outputNumeroToStandby = outputNumeroToStandby;
        this.outputNumeroToStandback = outputNumeroToStandback;
    }
    
    /**
     * Move SFT autochanger trucks to STANDBACK position.
     * @return
     * @throws FcsHardwareException 
     */
    @Override
    public String moveToStandback()  {
        this.setMovingToStandback(true);
        return dio.getTcpProxy().writeSDO(dio.getNodeID(), 0x6200, 1, 1, 1);

    }

    /**
     * Move SFT autochanger trucks to STANDBY position.
     * @return
     * @throws FcsHardwareException 
     */
    @Override
    public String moveToStandby()  {
        this.setMovingToStandby(true);
        return dio.getTcpProxy().writeSDO(dio.getNodeID(), 0x6200, 1, 1, 2);
    }

    @Override
    public String off()  {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return dio.getTcpProxy().writeSDO(dio.getNodeID(), 0x6200, 1, 1, 0);
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\noutputNumeroToStandby=");
        sb.append(outputNumeroToStandby);
        sb.append("\noutputNumeroToStandback=");
        sb.append(outputNumeroToStandback);
        return sb.toString();
    }

}
