
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;

import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

/**
 *
 * @author virieux
 */
public class SimuLoaderCarrierController extends SimuEPOSControllerModule {

    @LookupField(strategy=Strategy.BYNAME)
    private LoaderCarrierModule carrier;
    
    @LookupField(strategy=Strategy.BYNAME)
    private LoaderModule loader;
    
    private final SimuLoaderPlutoGateway plutoGateway;

    /**
     * Build a new SimuLoaderCarrierController
     * @param nodeID
     * @param serialNB
     * @param plutoGateway
     * @param paramsForCurrent
     * @param paramsForProfilePosition
     * @param paramsForHoming 
     */
    public SimuLoaderCarrierController(
            int nodeID, String serialNB,
            SimuLoaderPlutoGateway plutoGateway,
            Map<String, Integer> paramsForCurrent,
            Map<String, Integer> paramsForProfilePosition,
            Map<String, Integer> paramsForHoming
    ) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.plutoGateway = plutoGateway;
    }

    /**
     * 
     * @param positionToReached
     * @throws SDORequestException 
     */
    @Override
    public void writeTargetPosition(int positionToReached)  {
        
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSLOG.debug("loader carrier is moving.");
        FCSLOG.debug(name + "=>position intitiale=" + position);
        int stepsNB = 20;
        int step = (targetPosition - this.position) / stepsNB;

        for (int i = 1; i < stepsNB; i++) {
            try {

                this.position = positionInitiale + (i * step);
                carrier.updatePosition();
                if (position == carrier.getHandoffPosition()) {
                    FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (position == carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                loader.updateStateWithSensors();
                carrier.publishData();
                FCSLOG.debug(name + "i=" + i + ",position=" + position);
                try {
                    Thread.sleep(500);
                    if (carrier.getHaltRequired().get()) {
                        FCSLOG.debug(name + " STOP simulated carrrier motion.");
                        return;
                    }
                } catch (InterruptedException ex) {
                    throw new RejectedCommandException(name + " sleep was interrupted.");
                }

            } catch (FcsHardwareException ex) {
                FCSLOG.error(ex);
                throw new RejectedCommandException(ex.getMessage());
            }

        }
        this.position = targetPosition;
        if (position == carrier.getHandoffPosition()) {
            FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (position == carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }

    }


}
