package org.lsst.ccs.subsystems.fcs.simulation;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 *
 * @author virieux
 */
public class SimuCanOpenProxy extends CanOpenProxy {

    public SimuCanOpenProxy(int portNumber, int fieldBusTimeout, String clientName,
            long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout, clientName, hardwareBootTimeout);
    }

    @Override
    public void init() {
        super.init();
        this.hardwareBootProcessEnded = true;
    }

    @Override
    public void startServer() {
        tcpServerStarted = true;
        stopped = false;
    }

    @Override
    public void startThreadReader() {
    }

    @Override
    public void stopServer() {
        stopped = true;
        tcpServerStarted = false;
    }

    @Override
    public void bootProcess() {
        this.getSubsystem().updateAgentState(FcsEnumerations.FilterState.HOMING_TO_BE_DONE, 
                FcsEnumerations.FilterReadinessState.NOT_READY);
        for (PieceOfHardware device : hardwareMapByNodeID.values()) {
            device.setBooted(true);
            this.bootedDeviceNB ++;
        }        
        publishData();
    }
    
    /**
     * In simulation, call method only logs the command to be called.
     * @param clientName
     * @param command
     * @return 
     */
    @Override
    public Object call(String clientName, String command) {
        FCSLOG.debug(name + "/call command: " + command);
        return "OK";
    }
   
    @Override
    public PDOStorage readPDOs()  {
        FCSLOG.debug(name + "/readPDOS");
        return this.getPdoStorage();
    }
    
    /**
     * 
     * @param nodeID
     * @param index
     * @param subindex
     * @return 
     */
    @Override
    public int readSDO(int nodeID, int index, int subindex)  {
        FCSLOG.debug("in Simulation, readSDO returns always 0");
        FCSLOG.debug("command sent: " + FcsUtils.buildRsdoCommand(nodeID, index, subindex));
        return 0;
    }
   
    @Override
    public String writeSDO(int nodeID, int index, int subindex, int size, int newValue) {
        FCSLOG.debug("writeSDO("+nodeID+','+index+','+subindex+','+size+','+newValue+')');
        return "OK";
    }
    
    @Override
    public boolean allDevicesBooted() {
        return true;
    }
    
    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isRealHardware() {
        return false;
    }

}
