package org.lsst.ccs.subsystems.fcs.drivers;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * The tcp server for the loader when we want to connect or disconnect loader
 * hardware. So this tcp proxy won't start during initialisation phase.
 *
 * @author virieux
 */
public class LoaderCanOpenProxy extends CanOpenProxy {

    public LoaderCanOpenProxy(int portNumber, int fieldBusTimeout, String clientName, long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout, clientName, hardwareBootTimeout);
    }

    /**
     * We don't want the tcp server to be started during INITIALISATION phase.
     */
    @Override
    public void start() {
        FCSLOG.debug(name + ": START DU TCP PROXY DU LOADER : nothing to start !");
    }
    
    @Override
    public void postStart() {
      /*We want that the postStart method does nothing during INITIALISATION phase
       for the loader tcpProxy because the loader hardware might be not connected. */  
    }

    /**
     * This methods connect the CWrapper client, and the TCP server and check
     * the hardware.
     *
     */
    @Override
    public void connectHardware() {
        super.connectHardware();
        super.postStart();
    }
}
