/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

/**
 * This is a model for an Emergency message comming from the CANbus. It's
 * created by CanOPenProxy and proceeded by the CanOpenProxy's Observers. see
 * CanOpenErrorsTable
 *
 * @author virieux
 */
public class EmergencyMessage {

    private final int nodeID;
    private final String deviceName;
    private final int deviceErrorCode; //see properties deviceErrorCodes
    private final String deviceErrorName;
    private final int errorRegisterCode; //see properties errorRegisterCodes
    private final String errorRegisterName;

    /**
     * Creates a new EmergencyMessage
     * @param nodeID
     * @param deviceName
     * @param deviceErrorCode
     * @param deviceErrorName
     * @param errorRegisterCode
     * @param errorRegisterName 
     */
    public EmergencyMessage(int nodeID, String deviceName, int deviceErrorCode,
            String deviceErrorName, int errorRegisterCode, String errorRegisterName) {
        this.nodeID = nodeID;
        this.deviceName = deviceName;
        this.deviceErrorCode = deviceErrorCode;
        this.deviceErrorName = deviceErrorName;
        this.errorRegisterCode = errorRegisterCode;
        this.errorRegisterName = errorRegisterName;
    }

    public int getNodeID() {
        return nodeID;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public int getDeviceErrorCode() {
        return deviceErrorCode;
    }

    public String getDeviceErrorName() {
        return deviceErrorName;
    }

    public int getErrorRegisterCode() {
        return errorRegisterCode;
    }

    public String getErrorRegisterName() {
        return errorRegisterName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Emergency message received from CANbus");
        sb.append(",for nodeID=");
        sb.append(Integer.toHexString(nodeID));
        sb.append(",deviceName=");
        sb.append(deviceName);
        sb.append(",deviceErrorCode=");
        sb.append(Integer.toHexString(deviceErrorCode));
        sb.append(",deviceErrorName=");
        sb.append(deviceErrorName);
        sb.append(",errorRegisterCode=");
        sb.append(Integer.toHexString(errorRegisterCode));
        sb.append(",errorRegisterName=");
        sb.append(errorRegisterName);
        return sb.toString();
    }

}
