
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This interface is a model for a ADC : a Acquisition device.
 * The carousel clamps sensors are read through a ADC.
 * 
 * @author virieux
 */
public interface ADCInterface {

    /**
     * Read the analog input whom number is given as a parameter
     *
     * @param inputNB
     * @return the value read in hexa (on 16bits)
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     * @throws org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException
     * @throws FcsHardwareException
     * org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException
     */
    int readAnalogInput(int inputNB) ;

    /**
     * Read the voltage at the ADC input inputNB on the ADC and returns the
     * value in Volt
     *
     * @param inputNB : integer from 1 to 8
     * @return the value read in hexa (on 16bits)
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     * @throws org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException
     * @throws FcsHardwareException
     * org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException
     */
    double readVoltage(int inputNB) ;
    
}
