package canOpenSensor14bitsTest

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.description.groovy.CCSBuilder

//Carousel Can Open Devices (CAN-CBX-AI814) for Carousel brakes status + brakes temperatures
def adcName = "ai814"

CCSBuilder builder = ["sensor14bits"]

builder.
    
    main ( MainModule,
    
    bridge:ref("tcpProxy")
)
                    
//begin description of Main submodules
{       
    // tcp Proxy
    tcpProxy (SimuCanOpenProxy,
        
        portNumber:54321,
        fieldBusTimeout:2000,
        clientName:"TestBench",
        hardwareBootTimeout:2500, 
    ) {
        
        // can open devices to read brakes sensors and temperatures
        ai814 (SimuCanOpenADC,
            nodeID:0x1e,serialNB:"c7yyyyyy",transmissionType:1)
    }
    
    sensor14bits (CanOpenSensor14bits,
        
        adc:ref("$adcName"),
        numOfAnalogInput:5)
    
    
}
