#!/bin/sh
###############################################################################################
#This file generates a carousel_description file to be used in the whole fcs description file.
###############################################################################################

#Directory where one can find the groovy description files
source .setupFCS_BIN
echo "RESOURCES_DIR=$RESOURCES_DIR"

echo "SCRIPTS_DIR=$SCRIPTS_DIR"


#the SOCKET_MODEL is used to generate automaticaly the sockets description files
SOCKET_MODEL_FILENAME=socket__simulation__model.groovy
echo "SOCKET_MODEL_FILENAME=$SOCKET_MODEL_FILENAME"

#the file this script is going to generate
CAROUSEL_FILENAME=carousel_description

#filterManager description filename
FILTER_MGR_DESC=filterManager_description

#carousel head file
CAROUSELHEAD=carousel__head

#tail file
CAROUSELTAIL=carousel__tail

#Directory to save files
TMPDIR=/Users/virieux/tmp/

cd $RESOURCES_DIR

### Test if SOCKET_MODEL exists ###
if [ -f $SOCKET_MODEL_FILENAME ]; then 
	echo "Generation of sockets file from model SOCKET_MODEL_FILENAME=$SOCKET_MODEL_FILENAME";
        echo "The generated files are in $TMPDIR"
else
	echo "ERROR in execution of $0: $SOCKET_MODEL_FILENAME : no such file or directory in $RESOURCES_DIR"; 
	exit 0; 
fi

### SOCKET_MODEL exists ####

SOCKET_NUMBER=1; while [ $SOCKET_NUMBER -lt 6 ] ;
do
 echo "Generation of description groovy file for socket$SOCKET_NUMBER";
 cat $SOCKET_MODEL_FILENAME | sed -e "s/SOCKET_NUMBER/$SOCKET_NUMBER/g" > $TMPDIR/socket$SOCKET_NUMBER
 SOCKET_NUMBER=`expr $SOCKET_NUMBER + 1`;
done

### save existing carousel description file ###
echo "Saving $CAROUSEL_FILENAME in $TMPDIR"
DATE=`date '+%Y%m%d_%H%M%S'`
cp $CAROUSEL_FILENAME $TMPDIR/$CAROUSEL_FILENAME.$DATE

### Generation of file CAROUSEL_FILENAME

echo "Generation of $CAROUSEL_FILENAME from $CAROUSELHEAD, sockets files and $CAROUSELTAIL"

chmod u+w $CAROUSEL_FILENAME
cat $CAROUSELHEAD $TMPDIR/socket1 $TMPDIR/socket2 $TMPDIR/socket3 $TMPDIR/socket4 $TMPDIR/socket5 $CAROUSELTAIL > $CAROUSEL_FILENAME
chmod u-w $CAROUSEL_FILENAME



