/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SimuCompactIOModule;

public class SimuLatchActuatorModule
extends LatchActuatorModule
implements UsesSubsystem {
    private final SimuCompactIOModule simuDIO;

    public SimuLatchActuatorModule(SimuCompactIOModule simuDIO, double currentLimitInVolt, double speedVoltageInVolt, int speedVoltageMinValue, int speedVoltageMaxValue) {
        super(currentLimitInVolt, speedVoltageInVolt, speedVoltageMinValue, speedVoltageMaxValue);
        this.simuDIO = simuDIO;
    }

    @Override
    public String open() {
        int unlockSensorInputNumero;
        int lockSensorInputNumero;
        ComponentLookup lookup = this.getComponentLookup();
        if (this.name.endsWith("Xminus")) {
            lockSensorInputNumero = ((DigitalSensor)lookup.getComponentByName("lockSensorLatchXminus")).getInputNumero();
            unlockSensorInputNumero = ((DigitalSensor)lookup.getComponentByName("unlockSensorLatchXminus")).getInputNumero();
        } else if (this.name.endsWith("Xplus")) {
            lockSensorInputNumero = ((DigitalSensor)lookup.getComponentByName("lockSensorLatchXplus")).getInputNumero();
            unlockSensorInputNumero = ((DigitalSensor)lookup.getComponentByName("unlockSensorLatchXplus")).getInputNumero();
        } else {
            throw new FailedCommandException(this.name + " Can't retrieve the latch for which I work.");
        }
        this.simuDIO.replaceDigitalValues(lockSensorInputNumero, 0, unlockSensorInputNumero, 1);
        FCSCst.FCSLOG.debug((Object)(this.name + " is OPEN"));
        return this.name + " is OPEN";
    }

    @Override
    public String close() {
        int unlockSensorInputNumero;
        int lockSensorInputNumero;
        ComponentLookup lookup = this.getComponentLookup();
        if (this.name.endsWith("Xminus")) {
            lockSensorInputNumero = ((DigitalSensor)lookup.getComponentByName("lockSensorLatchXminus")).getInputNumero();
            unlockSensorInputNumero = ((DigitalSensor)lookup.getComponentByName("unlockSensorLatchXminus")).getInputNumero();
        } else if (this.name.endsWith("Xplus")) {
            lockSensorInputNumero = ((DigitalSensor)lookup.getComponentByName("lockSensorLatchXplus")).getInputNumero();
            unlockSensorInputNumero = ((DigitalSensor)lookup.getComponentByName("unlockSensorLatchXplus")).getInputNumero();
        } else {
            throw new FailedCommandException(this.name + " Can't retrieve the latch for which I work.");
        }
        this.simuDIO.replaceDigitalValues(lockSensorInputNumero, 1, unlockSensorInputNumero, 0);
        return this.name + " is CLOSED";
    }

    @Override
    public String powerOff() {
        return this.name + " is OFF";
    }
}

