/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;

public class SftMainModule
extends MainModule {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Filter dummyFilter;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private SftCarouselModule carousel;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private SftAutoChangerModule autochanger;
    private boolean filterLocated = false;

    public SftMainModule(BridgeToHardware bridge) {
        super(bridge);
    }

    public Filter getDummyFilter() {
        return this.dummyFilter;
    }

    public void postStart() {
        if (this.allDevicesBooted() && !this.filterLocated) {
            this.locateFilter();
            this.filterLocated = true;
            FCSCst.FCSLOG.info((Object)"Filter has been located. Hardware is ready to receive commands.");
            this.filterLocated = false;
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the sensors and update location of the filter and state of Carousel and Autochanger.")
    public void locateFilter() {
        this.carousel.updateClampsStateWithSensors();
        if (this.carousel.getClampXminus().getClampState().equals(FcsEnumerations.FilterClampState.CLAMPEDONFILTER) || this.carousel.getClampXminus().getClampState().equals(FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            this.carousel.getSocketByName("socket1").putFilterOnSocket(this.dummyFilter);
        }
        this.autochanger.updateLatchesStateWithSensors();
        if (!this.autochanger.isTrucksEmpty()) {
            this.autochanger.setFilterOnTrucks(this.dummyFilter);
        }
        this.autochanger.updateTrucksLocationWithSensors();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the carousel is ready to unlock the clamps in a safe way for the filter.", alias="checkUnlock")
    public void checkPreConditionsForUnlockClamps() {
        this.updateStateWithSensors();
        if (this.carousel.isHoldingFilterAtStandby() && !this.autochanger.isHoldingFilterAtStandby()) {
            throw new FailedCommandException("Can't unlock clamps if filter is not held by autochanger.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="To display at a console the status of the hardware.")
    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getSubsystem().getName()).append("\n  ");
        FCSCst.FCSLOG.info((Object)("Carousel status=" + this.carousel.toString()));
        sb.append(this.carousel.toString());
        sb.append("\n  ");
        sb.append("clampXminus status=");
        sb.append(this.carousel.getClampXminus().toString());
        sb.append("\n  ");
        sb.append("clampXplus status=");
        sb.append(this.carousel.getClampXplus().toString());
        sb.append("\n  ");
        FCSCst.FCSLOG.info((Object)("autochanger status=" + this.autochanger.toString()));
        sb.append(this.autochanger.toString());
        sb.append("\n  ");
        sb.append("latchXminus status=");
        sb.append(this.autochanger.getLatchXminus().toString());
        sb.append("\n  ");
        sb.append("latchXplus status=");
        sb.append(this.autochanger.getLatchXplus().toString());
        sb.append("\n  ");
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the hardware to the initial state : ")
    public String goToInitialState() {
        this.updateStateWithSensors();
        String ack = "Hardware is at initial state and ready for a sequence1";
        if (this.carousel.isHoldingFilterAtStandby()) {
            if (this.autochanger.isAtStandback()) {
                return ack;
            }
            if (this.autochanger.isAtStandby()) {
                FCSCst.FCSLOG.info((Object)"=======> Autochanger moving back empty to online position.");
                this.autochanger.ungrabFilterAtStandby();
                return ack;
            }
            if (this.autochanger.isTrucksEmpty()) {
                return this.autochanger.goToStandback();
            }
            return "Autochanger trucks are in the midle, but not empty, I don't know what to do.";
        }
        if (this.autochanger.isHoldingFilterAtStandback()) {
            if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
                this.carousel.releaseClamps();
            }
            FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
            this.autochanger.moveFilterToStandby(this.dummyFilter);
            FCSCst.FCSLOG.info((Object)"=======> Carousel is grabbing filter at standby position.");
            this.carousel.grabFilterAtStandby(this.getDummyFilter());
            FCSCst.FCSLOG.info((Object)"=======> Autochanger moving back empty to online position.");
            this.autochanger.ungrabFilterAtStandby();
            return ack;
        }
        if (this.autochanger.isHoldingFilterAtStandby()) {
            FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move loaded with the filter to standback position.");
            this.autochanger.moveFilterToStandback(this.dummyFilter);
            FCSCst.FCSLOG.info((Object)"=======> Carousel about to release Clamps.");
            this.carousel.releaseClamps();
            FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
            this.autochanger.moveFilterToStandby(this.dummyFilter);
            FCSCst.FCSLOG.info((Object)"=======> Carousel is grabbing filter at standby position.");
            this.carousel.grabFilterAtStandby(this.getDummyFilter());
            FCSCst.FCSLOG.info((Object)"=======> Autochanger moving back empty to online position.");
            this.autochanger.ungrabFilterAtStandby();
            return ack;
        }
        if (!this.autochanger.isAtStandback() && !this.autochanger.isAtStandby()) {
            return "Autochanger trucks are in the midle, I don't know what to do.";
        }
        return "Nobody holds the filter : I don't know how to go to initial state.";
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="The world famous sequence 1", alias="es1")
    public String executeSequence1() {
        FCSCst.FCSLOG.info((Object)"=======> BEGIN Execution of Sequence1.");
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move empty to standby position.");
        this.autochanger.grabFilterAtStandby(this.dummyFilter);
        if (this.haltRequired.get()) {
            return this.name + " Execution of Sequence1 HALTED at step 1";
        }
        FCSCst.FCSLOG.info((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.ungrabFilterAtStandby(this.dummyFilter.getName());
        if (this.haltRequired.get()) {
            return this.name + " Execution of Sequence1 HALTED at step 2";
        }
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move loaded with the filter to standback position.");
        this.autochanger.moveFilterToStandback(this.dummyFilter);
        FCSCst.FCSLOG.info((Object)"=======> Carousel about to release Clamps.");
        this.carousel.releaseClamps();
        if (this.haltRequired.get()) {
            return this.name + " Execution of Sequence1 HALTED at step 3";
        }
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
        this.autochanger.moveFilterToStandby(this.dummyFilter);
        FCSCst.FCSLOG.info((Object)"=======> Carousel is grabbing filter at standby position.");
        this.carousel.grabFilterAtStandby(this.getDummyFilter());
        if (this.haltRequired.get()) {
            return this.name + " Execution of Sequence1 HALTED at step 4";
        }
        FCSCst.FCSLOG.info((Object)"=======> Autochanger moving back empty to online position.");
        this.autochanger.ungrabFilterAtStandby();
        FCSCst.FCSLOG.info((Object)"=======> Execution of Sequence1 completed.");
        return "Execution of Sequence1 completed";
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="The world famous sequence 1 (with number of repetitions)", alias="es1")
    public String executeSequence1(@Argument(name="nExecutions", description="Number of executions") int nb) {
        if (nb < 1 || nb > 20000) {
            throw new IllegalArgumentException("nb has to be comprise between 1 and 20000");
        }
        for (int i = 1; i < nb + 1; ++i) {
            FCSCst.FCSLOG.info((Object)("===========================BEGIN execution Sequence1 nb=" + i + " ================"));
            this.executeSequence1();
            FCSCst.FCSLOG.info((Object)("===========================END execution Sequence1 nb=" + i + " ================"));
        }
        return this.name + ":" + nb + " executions of Sequence1 completed";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("\n").append(this.carousel.toString());
        sb.append("\n").append(this.autochanger.toString());
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read the sensors and update the state of the carousel and the autochanger.")
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }
}

