/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderClampController
extends SimuEPOSControllerModule {
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private LoaderClampModule clamp;
    private final SimuLoaderPlutoGateway plutoGateway;

    public SimuLoaderClampController(int nodeID, String serialNB, SimuLoaderPlutoGateway plutoGateway, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.plutoGateway = plutoGateway;
    }

    @Override
    public void writeCurrent(int aValue) {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        FCSCst.FCSLOG.debug((Object)("=>initial current=" + this.actualCurrent));
        int stepsNB = 10;
        int step = (this.targetCurrent - this.actualCurrent) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            this.actualCurrent = (short)(currentInitial + i * step);
            this.clamp.updateCurrent();
            if (this.actualCurrent == this.clamp.getCurrentToClamp()) {
                FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                this.position = this.clamp.getTargetPositionToClamp();
                this.plutoGateway.simulateLoaderClampIsClosed();
            } else if (this.actualCurrent == this.clamp.getCurrentToOpen()) {
                this.position = this.clamp.getTargetPositionToOpen();
                this.plutoGateway.simulateLoaderClampIsOpened();
            }
            this.clamp.publishData();
            FCSCst.FCSLOG.debug((Object)("i=" + i + ",actualCurrent=" + this.actualCurrent));
            try {
                Thread.sleep(500L);
                if (!this.clamp.getHaltRequired().get()) continue;
                FCSCst.FCSLOG.debug((Object)(this.name + " STOP simulated clamp motion."));
                return;
            }
            catch (InterruptedException ex) {
                throw new FcsHardwareException(this.name + " sleep was interrupted.", ex);
            }
        }
        this.actualCurrent = aValue;
        if (this.actualCurrent == this.clamp.getCurrentToClamp()) {
            FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.position = this.clamp.getTargetPositionToClamp();
            this.plutoGateway.simulateLoaderClampIsClosed();
        } else if (this.actualCurrent == this.clamp.getCurrentToOpen()) {
            this.position = this.clamp.getTargetPositionToOpen();
            this.plutoGateway.simulateLoaderClampIsOpened();
        }
        this.clamp.publishData();
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.info((Object)("=>position intitiale=" + this.position));
        FCSCst.FCSLOG.info((Object)("=>targetPosition=" + this.targetPosition));
        FCSCst.FCSLOG.info((Object)("clamp.getTargetPositionToClamp()=" + this.clamp.getTargetPositionToClamp()));
        FCSCst.FCSLOG.info((Object)("clamp.getRelativePositionToUnclamp()=" + this.clamp.getRelativePositionToUnclamp()));
        int stepsNB = 10;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            this.position = positionInitiale + i * step;
            this.clamp.updatePosition();
            this.simulateSensors();
            FCSCst.FCSLOG.info((Object)("i=" + i + ",position=" + this.position));
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ex) {
                throw new RejectedCommandException(this.name + " sleep was interrupted.");
            }
        }
        this.position = this.targetPosition;
        FCSCst.FCSLOG.info((Object)("i=10,position=" + this.position));
        this.simulateSensors();
    }

    private void simulateSensors() {
        if (this.position == this.clamp.getTargetPositionToOpen()) {
            FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.plutoGateway.simulateLoaderClampIsOpened();
        } else if (this.position == this.clamp.getRelativePositionToClose()) {
            this.plutoGateway.simulateLoaderClampIsClosed();
        } else if (this.position == this.clamp.getTargetPositionToClamp()) {
            this.plutoGateway.simulateLoaderClampIsClamped();
        } else if (this.position == this.clamp.getTargetPositionToClamp() + this.clamp.getRelativePositionToUnclamp()) {
            this.plutoGateway.simulateLoaderClampIsClosed();
        } else {
            this.plutoGateway.simulateLoaderClampIsInTravel();
        }
        this.clamp.publishData();
    }
}

