/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuCanOpenProxy
extends CanOpenProxy {
    public SimuCanOpenProxy(int portNumber, int fieldBusTimeout, String clientName, long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout, clientName, hardwareBootTimeout);
    }

    @Override
    public void init() {
        super.init();
        this.hardwareBootProcessEnded = true;
    }

    @Override
    public void startServer() {
        this.tcpServerStarted = true;
        this.stopped = false;
    }

    @Override
    public void startThreadReader() {
    }

    @Override
    public void stopServer() {
        this.stopped = true;
        this.tcpServerStarted = false;
    }

    @Override
    public void bootProcess() {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HOMING_TO_BE_DONE, FcsEnumerations.FilterReadinessState.NOT_READY});
        for (PieceOfHardware device : this.hardwareMapByNodeID.values()) {
            device.setBooted(true);
            ++this.bootedDeviceNB;
        }
        this.publishData();
    }

    @Override
    public Object call(String clientName, String command) {
        FCSCst.FCSLOG.debug((Object)(this.name + "/call command: " + command));
        return "OK";
    }

    @Override
    public PDOStorage readPDOs() {
        FCSCst.FCSLOG.debug((Object)(this.name + "/readPDOS"));
        return this.getPdoStorage();
    }

    @Override
    public int readSDO(int nodeID, int index, int subindex) {
        FCSCst.FCSLOG.debug((Object)"in Simulation, readSDO returns always 0");
        FCSCst.FCSLOG.debug((Object)("command sent: " + FcsUtils.buildRsdoCommand(nodeID, index, subindex)));
        return 0;
    }

    @Override
    public String writeSDO(int nodeID, int index, int subindex, int size, int newValue) {
        FCSCst.FCSLOG.debug((Object)("writeSDO(" + nodeID + ',' + index + ',' + subindex + ',' + size + ',' + newValue + ')'));
        return "OK";
    }

    @Override
    public boolean allDevicesBooted() {
        return true;
    }

    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isRealHardware() {
        return false;
    }
}

