/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public abstract class PlutoGatewayModule
extends CanOpenDevice
implements PlutoGatewayInterface {
    protected int[] hexaValues;
    protected volatile boolean updatingValues = false;
    protected final Lock lock = new ReentrantLock();
    protected final Condition valueUpdated = this.lock.newCondition();

    public PlutoGatewayModule(int nodeID, String serialNB) {
        super(nodeID, serialNB);
        this.hexaValues = new int[16];
    }

    public int[] getIntValues() {
        return this.getHexaValues();
    }

    @Override
    public int[] getHexaValues() {
        this.lock.lock();
        try {
            while (this.updatingValues) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ex.getMessage()));
                }
            }
            int[] nArray = this.hexaValues;
            return nArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateValues() {
        this.lock.lock();
        try {
            this.updatingValues = true;
            this.hexaValues = this.readNewHexaValues();
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signalAll();
            this.lock.unlock();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1)
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (int i = 0; i < this.hexaValues.length; ++i) {
            sb.append("/byte");
            sb.append(i);
            sb.append('=');
            sb.append(String.valueOf(this.hexaValues[i]));
        }
        return sb.toString();
    }

    public StatusDataPublishedByPlutoGateway createStatusDataPublishedByPlutoGatewayModule() {
        return new StatusDataPublishedByPlutoGateway(this.getName(), this.isBooted(), this.isInitialized(), this.hexaValues);
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByPlutoGatewayModule()));
    }
}

