/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.drivers.CommandDispenser;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.utilities.beanutils.WrappedException;
import org.lsst.ccs.utilities.logging.Logger;

abstract class FcsTcpProxy
implements AlertRaiser,
HasLifecycle {
    public static final Logger COMMAND_LOG = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs.CommandDispenser");
    @LookupName
    protected String name;
    @ConfigurationParameter(isFinal=true, range="1024..99000", description="tcpip port number on which this tcpip server starts on.")
    protected int portNumber;
    @ConfigurationParameter(description="Timeout in Millisecond. If a command sent to the CANbus doesn't respond during this amount of time, we considere that they could be an issue on the hardware.")
    protected int fieldBusTimeout;
    private ServerSocket serverSock;
    private Thread readerThread;
    protected volatile boolean stopped = true;
    protected volatile boolean stopping = false;
    protected volatile boolean tcpServerStarted = false;
    protected ClientContext clientContext;
    private CommandDispenser commandDispenser;
    protected final Lock lock = new ReentrantLock();
    protected final Condition hardwareBooted = this.lock.newCondition();

    FcsTcpProxy(int portNumber, int fieldBusTimeout) {
        this.portNumber = portNumber;
        this.fieldBusTimeout = fieldBusTimeout;
    }

    public void init() {
        this.stopped = false;
        this.stopping = false;
        this.tcpServerStarted = false;
        this.commandDispenser = new CommandDispenser();
    }

    public void start() {
        this.startServer();
        this.startThreadReader();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Starts the tcp server.")
    public void startServer() {
        try {
            this.serverSock = new ServerSocket(this.portNumber);
            FCSCst.FCSLOG.info((Object)(this.name + ":SERVER STARTED ON PORT:" + this.portNumber));
        }
        catch (IOException e) {
            FCSCst.FCSLOG.error((Object)(this.name + ":server not started"), (Throwable)e);
            throw new WrappedException((Throwable)e);
        }
        try {
            FCSCst.FCSLOG.info((Object)(this.name + ":WAITING FOR C-WRAPPER CLIENT..."));
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.WAITING_FOR_CWRAPPER, FcsEnumerations.FilterReadinessState.NOT_READY});
            FCSCst.FCSLOG.debug((Object)(this.name + ":DEBUGGING MODE"));
            Socket sock = this.serverSock.accept();
            FCSCst.FCSLOG.info((Object)(this.name + ":socket accept on " + this.portNumber));
            BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
            String nameAndProtocol = reader.readLine();
            if (nameAndProtocol == null) {
                FCSCst.FCSLOG.error((Object)(this.name + ": nameAndProtocol is null : CWrapper disconnected ?. Bye."));
                this.stopServer();
            } else {
                String[] words = nameAndProtocol.split(" ");
                String cname = words[0];
                this.clientContext = new ClientContext(cname, sock, reader, sock.getOutputStream());
                FCSCst.FCSLOG.info((Object)(this.name + ":REGISTERED : " + cname));
                this.tcpServerStarted = true;
                this.stopped = false;
            }
        }
        catch (IOException e) {
            FCSCst.FCSLOG.error((Object)(this.name + " unexpected "), (Throwable)e);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Starts to listen to the tcp client.")
    public void startThreadReader() {
        FCSCst.FCSLOG.info((Object)(this.name + "startThreadReader"));
        if (!this.tcpServerStarted) {
            String errorMsg = this.getName() + " tcp server has to be started before startThreadReader.";
            throw new FcsHardwareException(errorMsg);
        }
        Runnable readingFromTcpProxy = new Runnable(){

            @Override
            public void run() {
                while (!FcsTcpProxy.this.stopped) {
                    try {
                        String readline = FcsTcpProxy.this.clientContext.reader.readLine();
                        if (readline == null) {
                            if (FcsTcpProxy.this.stopping) {
                                FCSCst.FCSLOG.info((Object)(FcsTcpProxy.this.name + " : CWrapper is stopped."));
                                continue;
                            }
                            FCSCst.FCSLOG.error((Object)(FcsTcpProxy.this.name + " :nameAndProtocol is null : that should not happen."));
                            continue;
                        }
                        FcsTcpProxy.this.processCommand(readline);
                    }
                    catch (IOException ex) {
                        FCSCst.FCSLOG.error((Object)ex);
                        FCSCst.FCSLOG.error((Object)(FcsTcpProxy.this.name + ": Error in Thread reading from the tcp client."));
                    }
                }
            }
        };
        FCSCst.FCSLOG.info((Object)(this.name + ":STARTING Thread reader"));
        this.readerThread = new Thread(readingFromTcpProxy);
        this.readerThread.start();
    }

    protected void processCommand(String command) {
        COMMAND_LOG.finest((Object)(this.name + ":message read from socket=" + command));
        String[] words = command.split(",");
        String commandWord = words[0];
        if (command.startsWith("emcy")) {
            this.processEmcyMessage(command);
        } else if (command.startsWith("Unknown")) {
            this.processUnknownCommand(command);
        } else if (command.startsWith("boot")) {
            int nodeID = Integer.parseInt(words[1], 16);
            FCSCst.FCSLOG.info((Object)(this.name + ":boot message received for nodeID (in hexa): " + Integer.toHexString(nodeID)));
            this.processBootMessage(nodeID);
        } else if (command.startsWith("sync")) {
            this.processCommandResponse(command, "sync");
        } else {
            int nodeID = Integer.parseInt(words[1], 16);
            this.processCommandResponse(command, commandWord + Integer.toHexString(nodeID));
        }
    }

    private void processCommandResponse(String command, String token) {
        COMMAND_LOG.finest((Object)("Command token=" + token));
        if (this.commandDispenser.isTokenUsed(token)) {
            COMMAND_LOG.finest((Object)("Response to a registred command:" + command));
            try {
                this.commandDispenser.registerResponse(token, command);
            }
            catch (Exception ex) {
                FCSCst.FCSLOG.error((Object)ex);
                FCSCst.FCSLOG.error((Object)(this.name + ":Error in registering response to command :" + command), ex.getCause());
            }
        } else {
            FCSCst.FCSLOG.warning((Object)(this.name + ":Unsynchronous message read from CANbus=" + command));
        }
    }

    public void shutdownNow() {
        this.stopServer();
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.OFF_LINE, FcsEnumerations.FilterReadinessState.NOT_READY});
    }

    public void stopServer() {
        if (!this.tcpServerStarted) {
            FCSCst.FCSLOG.warning((Object)(this.name + " is stopped; nothing to stop."));
            return;
        }
        FCSCst.FCSLOG.info((Object)(this.name + ": ABOUT TO STOP TCP server....."));
        FCSCst.FCSLOG.finest((Object)("clientName=" + this.clientContext.clientName));
        this.stopping = true;
        try {
            this.call(this.clientContext.clientName, "quit");
        }
        catch (CanOpenCallTimeoutException ex) {
            String msg = this.getName() + ": could not stop Cwrapper.";
            throw new FcsHardwareException(msg, ex);
        }
        catch (CWrapperNotConnected ex) {
            String msg = this.getName() + ": could not stop because CWrapper is not connected.";
            throw new FcsHardwareException(msg, ex);
        }
        this.stopped = true;
        this.readerThread.interrupt();
        try {
            this.serverSock.close();
            this.tcpServerStarted = false;
            FCSCst.FCSLOG.info((Object)(this.name + ": Subsystem " + this.getSubsystem().getName() + " TCPIP SERVER STOPPED:"));
        }
        catch (IOException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            FCSCst.FCSLOG.error((Object)(this.name + " : stop method does not work properly when closing socket"), (Throwable)ex);
        }
        try {
            this.clientContext.reader.close();
            this.clientContext.writer.close();
            this.clientContext.socket.close();
        }
        catch (IOException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            FCSCst.FCSLOG.error((Object)(this.name + " : stop method does not work properly"), (Throwable)ex);
        }
    }

    public synchronized boolean isReady(String clientName) {
        if (clientName == null) {
            throw new IllegalArgumentException("Client name can't be null.");
        }
        if (this.clientContext == null || this.clientContext.clientName == null) {
            return false;
        }
        if (this.stopped) {
            return false;
        }
        if (!this.tcpServerStarted) {
            return false;
        }
        FCSCst.FCSLOG.debug((Object)(this.name + "client name:= " + this.clientContext.clientName + "#"));
        return this.clientContext.clientName.equals(clientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object call(String clientName, String command) {
        if (this.clientContext == null) {
            throw new CWrapperNotConnected(this.portNumber, clientName, " could not send command:" + command);
        }
        if (this.stopped) {
            throw new IllegalStateException(this.name + ":textTCP module stopped");
        }
        String sentCommand = command + "\r\u0000\n";
        COMMAND_LOG.finest((Object)(this.name + ":Sent command=" + command));
        this.clientContext.writer.write(sentCommand, 0, sentCommand.length());
        this.clientContext.writer.flush();
        if (!command.startsWith("rsdo") && !command.startsWith("wsdo") && !command.startsWith("info") && !command.startsWith("sync") && !command.startsWith("srtr")) return "asynchronous command sent:" + command;
        String commandToken = this.commandDispenser.register(command);
        try {
            String string = this.commandDispenser.getCommandResponse(commandToken, this.fieldBusTimeout);
            this.commandDispenser.remove(commandToken);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.commandDispenser.remove(commandToken);
                throw throwable;
            }
            catch (IOException ex) {
                FCSCst.FCSLOG.error((Object)(this.name + ":ERROR in tcpProxy call method"));
                FCSCst.FCSLOG.error((Object)ex);
                throw new WrappedException(this.name + ":ERROR in tcpProxy call method " + clientName, (Throwable)ex);
            }
        }
    }

    abstract void processBootMessage(int var1);

    abstract void processEmcyMessage(String var1);

    protected void processUnknownCommand(String message) {
        this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, this.getName() + ": Unknown command received by CWrapper:" + message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/port=");
        sb.append(this.portNumber);
        return sb.toString();
    }

    protected static class ClientContext {
        private String clientName;
        private BufferedReader reader;
        private BufferedWriter writer;
        protected Socket socket;

        ClientContext(String name, Socket socket, BufferedReader reader, OutputStream os) {
            try {
                this.clientName = name;
                this.reader = reader;
                this.socket = socket;
                this.writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            }
            catch (UnsupportedEncodingException e) {
                FCSCst.FCSLOG.error((Object)(name + ":context not started"), (Throwable)e);
                throw new Error(e);
            }
        }
    }
}

