/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public class CanOpenTTC580
extends CanOpenDevice {
    long pdoVal = 0L;

    public CanOpenTTC580(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Command(type=Command.CommandType.QUERY, description="return PDO1 value")
    public long getPdoVal() {
        return this.pdoVal;
    }

    public void setPdoVal(long pdoVal) {
        this.pdoVal = pdoVal;
    }

    @Command(type=Command.CommandType.QUERY, description="send a sync command to CANbus, process response and update pdoVal.")
    public void updatePDO() {
        this.pdoVal = this.extractFirstPDO(this.tcpProxy.sendCanOpen("sync"));
    }

    protected long extractFirstPDO(String replyToSync) {
        String[] words = replyToSync.split(",");
        if (words[1].startsWith("PDO1") && words[0].split("=").length > 0) {
            String pdoValStr = words[1].split("=")[1];
            return Long.valueOf(pdoValStr, 16);
        }
        throw new IllegalArgumentException(this.name + " " + replyToSync + ": bad response to sync command. ");
    }

    @Command(type=Command.CommandType.QUERY, description="return socketId from PDO value")
    public short getSocketId() {
        return (short)(this.pdoVal >>> 61);
    }

    @Command(type=Command.CommandType.QUERY, description="return lock sensor for clampXminus")
    public int getLockXm() {
        return (int)(this.pdoVal >>> 36) & 0xFFF;
    }

    @Command(type=Command.CommandType.QUERY, description="return filter presence sensor for clampXminus")
    public int getFilterPresenceXm() {
        return (int)(this.pdoVal >>> 24) & 0xFFF;
    }

    @Command(type=Command.CommandType.QUERY, description="return lock sensor for clampXplus")
    public int getLockXp() {
        return (int)(this.pdoVal >>> 12) & 0xFFF;
    }

    @Command(type=Command.CommandType.QUERY, description="return filter presence sensor for clampXplus")
    public int getFilterPresenceXp() {
        return (int)this.pdoVal & 0xFFF;
    }
}

