/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class LoaderModule
implements HardwareController,
FilterHolder,
AlertRaiser,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private LoaderCarrierModule carrier;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private LoaderClampModule clamp;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private BridgeToHardware loaderTcpProxy;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private RedondantSensors loaderFilterPresenceSensors;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private RedondantSensors loaderOnCameraSensors;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private PlutoGatewayInterface loaderPlutoGateway;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private EPOSController hooksController;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private EPOSController carrierController;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public LoaderCarrierModule getCarrier() {
        return this.carrier;
    }

    public LoaderClampModule getClamp() {
        return this.clamp;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if hardware (controllers and plutoGateway) is correctly initializedand homing of the controllers is done.")
    public boolean isInitialized() {
        boolean devicesInitialized = this.loaderPlutoGateway.isInitialized() && this.hooksController.isInitialized() && this.carrierController.isInitialized();
        return devicesInitialized && this.clamp.isHomingDone() && this.carrier.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."), (Throwable)ex);
                }
            }
            boolean bl = !this.loaderFilterPresenceSensors.isOn();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."), (Throwable)ex);
                }
            }
            boolean bl = this.loaderOnCameraSensors.isOn();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        return this.autochanger.isHoldingFilter();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a filter is present and it is held by the loader clamp.")
    public boolean isHoldingFilter() {
        this.updateStateWithSensors();
        this.clamp.updatePosition();
        return this.clamp.isClamped() && !this.isEmpty();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Attention ! this commands does the homing of the controllers and might move hardware. Initialize loader hardware.", alias="homing")
    public void locateHardware() {
        boolean devicesInitialized;
        this.carrier.initializeHardware();
        boolean bl = devicesInitialized = this.loaderPlutoGateway.isInitialized() && this.hooksController.isInitialized() && this.carrierController.isInitialized();
        if (devicesInitialized) {
            this.updateStateWithSensors();
            this.checkNotEmptyAndClosed();
            if (this.isEmpty()) {
                this.homingWhenNoFilter();
            }
        } else {
            throw new FailedCommandException(this.name + " couldn't locate hardware because devices are not initialized.");
        }
        this.updateFCSStateToReady();
    }

    private void homingWhenNoFilter() {
        if (!this.carrier.isAtStoragePosition()) {
            this.carrier.goToStorage();
        }
        this.clamp.open();
    }

    private void checkNotEmptyAndClosed() {
        if (this.isEmpty() && this.clamp.isClosed()) {
            String msg = this.name + ": carrier is empty and clamp is CLOSED - can't start.";
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg, this.name);
            throw new FcsHardwareException(msg);
        }
    }

    public void postStart() {
        if (this.loaderPlutoGateway.isBooted()) {
            this.initializeGateway();
        } else {
            this.loaderPlutoGateway.raiseAlarmIfMissing();
        }
    }

    public void initializeGateway() {
        try {
            this.loaderPlutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize loaderPlutoGateway", ex);
        }
    }

    public void checkStarted() {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN checkStarted"));
        this.initializeGateway();
        FCSCst.FCSLOG.info((Object)(this.name + " END checkStarted"));
    }

    public void checkConnectedOnCamera() {
        if (!this.isConnectedOnCamera()) {
            throw new RejectedCommandException(this.name + " Loader not connected - can't execute commands.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the carrier can move.")
    public void checkConditionsForCarrierMotion() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for carrier motion"));
        this.updateStateAndCheckSensors();
        if (!this.isEmpty()) {
            if (this.isHoldingFilter() && this.isAutochangerHoldingFilter()) {
                throw new RejectedCommandException(this.name + " carrier can't move because a filter is in the loader and it's held by loader AND autochanger.");
            }
            if (!this.isHoldingFilter() && !this.isAutochangerHoldingFilter()) {
                throw new RejectedCommandException(this.name + " carrier can't move because the filter in the loader is not held neither by loader neither by autochanger. Close loader clamp or autochanger latches. ");
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the clamp can be opened.")
    public void checkConditionsForOpeningHooks() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for opening hooks"));
        this.updateStateAndCheckSensors();
        if (!this.isEmpty()) {
            if (!this.carrier.isAtHandoffPosition()) {
                String msg = this.name + ": carrier is loaded with a filter but not at handoff position - can't open clamp.";
                FCSCst.FCSLOG.error((Object)msg);
                throw new RejectedCommandException(msg);
            }
            if (!this.isAutochangerHoldingFilter()) {
                String msg = this.name + ": A filter is in the loader but not held by autochanger - can't open clamp.";
                FCSCst.FCSLOG.error((Object)msg);
                throw new RejectedCommandException(msg);
            }
        }
    }

    public void checkConditionsForUnclampingHooks() {
        if (!this.carrier.isAtHandoffPosition()) {
            String msg = this.name + ": carrier is loaded with a filter but not at handoff position - can't unclamp.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        if (this.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException(this.name + " Autochanger is holding filter. Can't unclamp Loader Clamp.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the clamp can be closed.")
    public void checkLoaderNotEmpty() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for closing hooks"));
        this.updateStateAndCheckSensors();
        this.clamp.updatePosition();
        if (this.isEmpty()) {
            String msg = this.name + ": no filter in loader - can't execute close, clamp command." + this.clamp.getName();
            FCSCst.FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
    }

    public void updateStateAndCheckSensors() {
        this.updateStateWithSensors();
        this.checkConnectedOnCamera();
        this.clamp.checkInitialized();
        this.clamp.checkSensors(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR);
        this.carrier.checkSensors(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.loaderTcpProxy.publishData();
        this.loaderPlutoGateway.checkBooted();
        this.loaderPlutoGateway.checkInitialized();
        this.lock.lock();
        try {
            this.updatingState = true;
            this.loaderPlutoGateway.updateValues();
            int[] readHexaValues = this.loaderPlutoGateway.getHexaValues();
            this.loaderFilterPresenceSensors.updateValue(readHexaValues);
            this.loaderOnCameraSensors.updateValue(readHexaValues);
            this.clamp.updateStateWithSensors(readHexaValues);
            this.carrier.updateStateWithSensors(readHexaValues);
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
            this.clamp.publishData();
            this.carrier.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.clamp.isHomingDone() && this.carrier.isInitialized()) {
            this.main.updateFCSStateToReady();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Load a filter from the loader into the camera.")
    public void loadFilterInCamera() {
        this.checkConnectedOnCamera();
        if (!this.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + ":loader is not holding a filter : can't load a filter into camera.");
        }
        if (!this.carrier.isAtStoragePosition()) {
            throw new RejectedCommandException(this.name + ":carrier loader is not at storage position : can't load a filter into camera.");
        }
        this.carrier.goToHandOff();
        if (this.main.isHaltRequired() || this.main.isStopRequired()) {
            throw new FailedCommandException(this.name + ": received HALT or STOP command.");
        }
        while (!this.isAutochangerHoldingFilter()) {
            FCSCst.FCSLOG.debug((Object)(this.name + " waiting until autochanger holds the filter..."));
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {
                throw new FcsHardwareException("loadFilterInCamera interrupted while waiting for the autochanger to take the filter", ex);
            }
            this.updateStateWithSensors();
        }
        if (this.isAutochangerHoldingFilter()) {
            this.clamp.open();
        }
        if (this.main.isHaltRequired() || this.main.isStopRequired()) {
            throw new FailedCommandException(this.name + ": received HALT or STOP command.");
        }
        this.carrier.goToStorage();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unload a filter from the camera into the loader.")
    public void unloadFilterFromCamera() {
        this.updateStateWithSensors();
        this.checkConnectedOnCamera();
        if (this.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + ":loader is holding a filter : can't unload a filter from camera.");
        }
        while (!this.isAutochangerHoldingFilter()) {
            FCSCst.FCSLOG.debug((Object)(this.name + " waiting until autochanger holds the filter..."));
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {
                throw new FcsHardwareException("unloadFilterFromCamera interrupted while waiting until autochanger holds the filter", ex);
            }
            this.updateStateWithSensors();
        }
        this.carrier.goToHandOff();
        if (this.main.isHaltRequired() || this.main.isStopRequired()) {
            throw new FailedCommandException(this.name + ": received HALT or STOP command.");
        }
        this.updateStateWithSensors();
        if (this.isEmpty()) {
            throw new FailedCommandException(this.name + ": loader presence filter sensor doesn't detect a filter - can't go on.");
        }
        this.clamp.close();
        while (this.isAutochangerHoldingFilter()) {
            FCSCst.FCSLOG.debug((Object)(this.name + " waiting until autochanger releases the filter..."));
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {
                throw new FcsHardwareException("unloadFilterFromCamera interrupted while waiting until autochanger releases the filter", ex);
            }
            this.updateStateWithSensors();
        }
        this.clamp.clamp();
        if (this.main.isHaltRequired() || this.main.isStopRequired()) {
            throw new FailedCommandException(this.name + ": received HALT or STOP command.");
        }
        this.carrier.goToStorage();
    }

    public StatusDataPublishedByLoader createStatusDataPublishedByLoader() {
        StatusDataPublishedByLoader status = new StatusDataPublishedByLoader();
        status.setName(this.name);
        status.setFilterPresenceSensorValue(this.loaderFilterPresenceSensors.isOn());
        status.setFilterPresenceSensorsInError(this.loaderFilterPresenceSensors.isInError());
        status.setLoaderOnCameraSensorValue(this.loaderOnCameraSensors.isOn());
        status.setLoaderOnCameraSensorsInError(this.loaderOnCameraSensors.isInError());
        return status;
    }

    public void publishData() {
        StatusDataPublishedByLoader status = this.createStatusDataPublishedByLoader();
        KeyValueData kvd = new KeyValueData("loaderGeneral", (Serializable)status);
        this.s.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public boolean isAtHandoff() {
        return this.carrier.isAtHandoffPosition();
    }

    @Override
    public boolean isAtStandby() {
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.carrier.printHardwareState());
        sb.append("\n");
        sb.append(this.clamp.printHardwareState());
        return sb.toString();
    }
}

