/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;

public class FakeFilterHolder
implements FilterHolder {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;
    private final PlutoGatewayInterface plutoGateway;
    private final BinarySensor holdingFilterSensor;
    @LookupName
    private String name;
    private boolean holdingFilter = false;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public FakeFilterHolder(PlutoGatewayInterface plutoGateway, BinarySensor holdingFilterSensor) {
        this.plutoGateway = plutoGateway;
        this.holdingFilterSensor = holdingFilterSensor;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the fake autochanger is holding the filter. This command doesn't read again the sensor.")
    public boolean isHoldingFilter() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.holdingFilter;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.plutoGateway.checkBooted();
        this.plutoGateway.checkInitialized();
        this.lock.lock();
        try {
            this.updatingState = true;
            this.plutoGateway.updateValues();
            this.computeState(this.plutoGateway.getHexaValues());
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void computeState(int[] hexaValues) {
        this.holdingFilterSensor.updateValue(hexaValues);
        this.holdingFilter = this.holdingFilterSensor.isOn();
    }

    public void publishData() {
        KeyValueData kvd = new KeyValueData(this.name, (Serializable)Boolean.valueOf(this.holdingFilterSensor.isOn()));
        this.s.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public boolean isAtHandoff() {
        return true;
    }

    @Override
    public boolean isAtStandby() {
        return true;
    }
}

