/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerTruck;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerTwoTrucks
extends MobileItemModule {
    AutochangerTruck truckXminus;
    AutochangerTruck truckXplus;
    private final int minActualPositionValue = 0;
    private final int maxActualPositionValue = 998000;
    @ConfigurationParameter(description="STANDBY position in micron")
    private int standbyPosition = 992000;
    @ConfigurationParameter(description="HANDOFF position in micron")
    private int handoffPosition = 70000;
    @ConfigurationParameter(description="ONLINE position in micron")
    private int onlinePosition = 2600;
    @ConfigurationParameter(description="timeout for trucks motion from ONLINE to STANDBY in milliseconds")
    private long timeoutForTrucksMotion = 20000L;
    @ConfigurationParameter(description="prelimary ONLINE position in micron, used by process whichmoves a filter at ONLINE position.")
    private int prelimaryTargetPosition = 3367;
    @ConfigurationParameter(description="natural position at ONLINE position in micron  used by process whichmoves a filter at ONLINE position.")
    private int naturalPosition = 3215;
    @ConfigurationParameter(description="minimum value of voltage read on proximitySensor. Unit: Volts")
    private double umin = 4.2;
    @ConfigurationParameter(description="maximum value of voltage read on proximitySensor. Unit: Volts")
    private double umax = 4.6;
    @ConfigurationParameter(description="voltage target on proximitySensor. Unit: Volts")
    private double utarget = 3.85;
    @ConfigurationParameter(description="adjustment factor. Unit: micrometre/volt")
    private double adjustmentFactor = 835.0;
    private int current = 0;
    private int speed = 0;
    private int masterPosition;
    private int slavePosition;
    private int deltaPosition;
    @ConfigurationParameter(description="masterPosition is reached if |targetPosition - masterPosition| < positionRange")
    private int positionRange = 2;
    @ConfigurationParameter(description="an alignment of slave must be done when |deltaPosition| > deltaPositionMax")
    private int deltaPositionMax = 100;
    private int absoluteTargetPosition = 0;
    private EPOSControllerForLinearRail linearRailMasterController;
    private EPOSControllerForLinearRail linearRailSlaveController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ADCInterface proximitySensorsDevice;
    @ConfigurationParameter(description="input number on the ADC where proximity sensor is plugged")
    private int proximitySensorInput = 1;
    private boolean atHandoff = false;
    private boolean atOnline = false;
    private boolean atStandby = false;
    private ScheduledFuture<?> checkPositionHandle;

    public AutochangerTwoTrucks(AutochangerTruck truckXminus, AutochangerTruck truckXplus, EPOSControllerForLinearRail linearRailMasterController, EPOSControllerForLinearRail linearRailSlaveController) {
        this.truckXminus = truckXminus;
        this.truckXplus = truckXplus;
        this.linearRailMasterController = linearRailMasterController;
        this.linearRailSlaveController = linearRailSlaveController;
    }

    @ConfigurationParameterChanger
    public void setNaturalPosition(int pos) {
        int minLimit = this.onlinePosition - 1500;
        int maxLimit = this.onlinePosition + 1500;
        if (pos < minLimit || pos > maxLimit) {
            throw new IllegalArgumentException(pos + " bad value for natural position must be > " + minLimit + " and < " + maxLimit);
        }
        this.naturalPosition = pos;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return actual trucks position (master position). Doesn't read again the position on the controller.")
    public int getPosition() {
        return this.masterPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return HANDOFF position. Doesn't read again the position on the controller.")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return STANDBY position. Doesn't read again the position on the controller.")
    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return ONLINE position. Doesn't read again the position on the controller.")
    public int getOnlinePosition() {
        return this.onlinePosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return timeout for trucks motion.")
    public long getTimeoutForTrucksMotion() {
        return this.timeoutForTrucksMotion;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at handoff position. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.atHandoff;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ONLINE position. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.atOnline;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STANDBY position. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.atStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the homing of the trucks has been done.")
    public boolean isHomingDone() {
        return this.linearRailSlaveController.isHomingDone() && this.linearRailMasterController.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if TruckXminus position sensors or TruckXminus position sensors are in error.")
    public boolean isPositionSensorsInError() {
        return this.truckXminus.isPositionSensorsInError() || this.truckXplus.isPositionSensorsInError() || this.positionSensorsNonConsistant();
    }

    private boolean positionSensorsNonConsistant() {
        return this.isAtStandby() && this.isAtHandoff() || this.isAtStandby() && this.isAtOnline() || this.isAtHandoff() && this.isAtOnline();
    }

    private void checkControllersName() {
        if (!this.truckXminus.getControllerName().contains("Master")) {
            throw new FcsHardwareException("truckXminus has to be controlled by Master controller.");
        }
        FCSLOG.info((Object)(this.name + " is controlled by " + this.truckXminus.getControllerName()));
        if (!this.truckXplus.getControllerName().contains("Slave")) {
            throw new FcsHardwareException("truckXplus has to be controlled by Slave controller.");
        }
        FCSLOG.info((Object)(this.name + " is controlled by " + this.truckXplus.getControllerName()));
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.linearRailSlaveController.isBooted() && this.linearRailMasterController.isBooted()) {
            this.initializeControllers();
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    public void initializeControllers() {
        try {
            this.checkControllersName();
            this.linearRailSlaveController.initializeAndCheckHardware();
            this.linearRailMasterController.initializeAndCheckHardware();
            this.homing();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.name, (Throwable)ex);
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Couldn't initialize controllers", this.name, ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure Autochanger trucks master and slave controllers.", alias="initControllers")
    public void configureControllers() {
        FCSLOG.info((Object)(this.name + " Begin configuration of the controllers"));
        this.linearRailMasterController.configureDigitalInputOfLinearRails();
        this.linearRailSlaveController.configureDigitalInputOfLinearRails();
        this.linearRailMasterController.configureDigitalOutputOfLinearRails();
        this.linearRailSlaveController.configureDigitalOutputOfLinearRails();
        FCSLOG.info((Object)(this.name + " End configuration of the controllers"));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if both controllers are initialized and homing of trucks are done.")
    public boolean isInitialized() {
        return this.linearRailMasterController.isInitialized() && this.linearRailSlaveController.isInitialized() && this.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the motion of trucks are allowed.")
    public void checkConditionsForTrucksMotion() {
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            String msg = this.name + " can't move autochanger trucks because controllers are not both initialized:\n";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        if (!this.isHomingDone()) {
            throw new RejectedCommandException(this.name + " can't be moved because the homing has not been done yet. ");
        }
        this.updatePosition();
        this.checkDeltaPosition();
        this.autochanger.checkFilterSafetyBeforeMotion();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.", alias="goToHandoff")
    public void goToHandOff() {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.moveToAbsoluteTargetPosition(this.onlinePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.moveToAbsoluteTargetPosition(this.standbyPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the absolute position given as argument. At the end of motion : doesn't align slave, active brakes and disable controllers", alias="mobeABSPos", timeout=20000)
    public void moveToAbsoluteTargetPosition(int targetPosition) {
        if (targetPosition < 0 || targetPosition > 998000) {
            throw new IllegalArgumentException(this.name + "argument has to be between " + 0 + " and " + 998000);
        }
        this.updatePosition();
        if (this.masterPosition == targetPosition) {
            FCSLOG.info((Object)(this.name + " is already at target position=" + targetPosition));
        } else {
            this.checkConditionsForTrucksMotion();
            this.checkControllersMode();
            this.checkReadyForAction();
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.name + " going to absolute position: " + this.absoluteTargetPosition));
            this.goToPosition(targetPosition);
            this.checkPositionSensors();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="goToOnline with filter, adjust position, close and lock clamps")
    public void moveAndClampFilterOnline() {
        FCSLOG.info((Object)(this.name + " BEGIN process docking ONLINE."));
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.moveToAbsoluteTargetPosition(this.prelimaryTargetPosition);
        this.alignSlave();
        double umeasured = this.proximitySensorsDevice.readVoltage(this.proximitySensorInput);
        int newTargetPosition = (int)((double)this.prelimaryTargetPosition + this.adjustmentFactor * (this.utarget - umeasured));
        FCSLOG.info((Object)(this.name + " new target position=" + newTargetPosition));
        this.moveToAbsoluteTargetPosition(newTargetPosition);
        this.autochanger.getOnlineClamps().closeAndLockClamps();
        umeasured = this.proximitySensorsDevice.readVoltage(this.proximitySensorInput);
        if (umeasured > this.umax) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too high.");
        } else if (umeasured < this.umin) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too low.");
        }
        this.goToPosition(this.naturalPosition);
        FCSLOG.info((Object)(this.name + " END process docking ONLINE."));
        this.autochanger.updateFCSStateToReady();
        this.publishData();
    }

    @Deprecated
    public void moveTrucksToPosition(int targetPosition) {
        this.updatePosition();
        this.checkConditionsForTrucksMotion();
        this.checkControllersMode();
        this.checkReadyForAction();
        this.goToPosition(targetPosition);
        this.publishData();
    }

    private void goToPosition(int targetPosition) {
        FCSLOG.info((Object)(this.name + " moving to position " + targetPosition));
        this.currentAction = FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION;
        this.absoluteTargetPosition = targetPosition;
        this.enableControllersAndReleaseBrake();
        try {
            this.linearRailMasterController.writeTargetPosition(targetPosition);
            this.linearRailMasterController.writeControlWord(63);
            this.checkActionCompleted(250, 250);
            this.waitForEndOfMotion(this.timeoutForTrucksMotion);
        }
        catch (CanOpenCallTimeoutException ex) {
            FCSLOG.error((Object)ex);
        }
        catch (Exception ex) {
            FCSLOG.error((Object)ex);
            throw new FcsHardwareException(this.name + " could not go to position: " + targetPosition + " because " + ex);
        }
        finally {
            this.stopGoingToPosition();
        }
        FCSLOG.info((Object)(this.name + " end moving to position " + targetPosition));
    }

    private void stopGoingToPosition() {
        this.linearRailMasterController.activateBrake();
        this.linearRailSlaveController.activateBrake();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)ex);
        }
        this.linearRailMasterController.stopPosition();
        this.linearRailMasterController.disable();
        this.linearRailSlaveController.disable();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                this.checkControllersMode();
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord(63);
                this.increaseCurrentMonitoring();
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Enable and release brake for the 2 controllers.")
    public void enableControllersAndReleaseBrake() {
        this.linearRailMasterController.enable();
        this.linearRailSlaveController.enable();
        this.linearRailMasterController.doReleaseBrake();
        if (!this.linearRailMasterController.isEnabled()) {
            throw new FcsHardwareException(this.name + " can't release Slave Controller brake  because Master Controller is disabled.");
        }
        this.linearRailSlaveController.doReleaseBrake();
    }

    private void checkControllersMode() {
        if (!this.linearRailMasterController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.name + " : linearRailMasterController is not in PROFILE_POSITION mode, can't move.");
        }
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER)) {
            throw new FcsHardwareException(this.name + " : linearRailSlaveController is not in MASTER_ENCODER mode, can't move. Slave controller mode =" + (Object)((Object)this.linearRailSlaveController.getMode()));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Align slave controller position to master controller position.")
    public void alignSlave() {
        if (this.linearRailMasterController.isEnabled()) {
            throw new FcsHardwareException(this.name + " master controller must be disabled.");
        }
        if (!this.linearRailMasterController.isBrakeActivated()) {
            throw new FcsHardwareException(this.name + " master controller brake must be activated.");
        }
        this.updatePosition();
        if (Math.abs(this.deltaPosition) > this.deltaPositionMax) {
            this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            try {
                this.doAlignSlave(this.masterPosition);
            }
            finally {
                this.stopAlignSlave();
            }
        }
    }

    private void stopAlignSlave() {
        FCSLOG.info((Object)(this.name + " STOP ALIGN SLAVE"));
        this.linearRailSlaveController.activateBrake();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)ex);
        }
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        this.linearRailSlaveController.disable();
        FCSLOG.info((Object)(this.name + " END STOP ALIGN SLAVE"));
    }

    private void doAlignSlave(int pos) {
        FCSLOG.info((Object)(this.name + " slave's alignment to be done. deltaPosition= " + this.deltaPosition));
        this.currentAction = FcsEnumerations.MobileItemAction.ALIGN_SLAVE;
        int timeoutForSlaveAlignment = 20000;
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.name + " can't align slave truck because couldn't change its mode to PROFILE_POSITION.");
        }
        this.linearRailSlaveController.enableAndReleaseBrake();
        this.linearRailSlaveController.writeTargetPosition(pos);
        this.linearRailSlaveController.writeControlWord(63);
        this.checkActionCompleted(250, 250);
        this.waitForEndOfMotion(timeoutForSlaveAlignment);
        this.publishData();
        FCSLOG.info((Object)(this.name + " end of slave's alignment. deltaPosition= " + this.deltaPosition));
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)(this.name + "ABORTING action: " + action.toString()));
        this.stopGoingToPosition();
        this.decreaseCurrentMonitoring();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.linearRailMasterController.quickStop();
        this.linearRailSlaveController.quickStop();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.info((Object)(this.name + " doing postAction: " + action.toString()));
        this.publishData();
        this.linearRailMasterController.activateBrakeAndDisable();
        this.linearRailSlaveController.activateBrakeAndDisable();
        FCSLOG.info((Object)(this.name + ":" + action.toString() + " completed - doing postAction: checking position sensors."));
        if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION) {
            this.checkPositionSensors();
        }
        this.publishData();
        this.alignSlave();
        this.autochanger.updateFCSStateToReady();
    }

    public void checkPositionSensors() {
        this.autochanger.updateStateWithSensors();
        if (this.absoluteTargetPosition == this.standbyPosition && !this.atStandby) {
            throw new FailedCommandException(this.name + ": check with sensors: STANDBY sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.handoffPosition && !this.atHandoff) {
            FCSLOG.info((Object)("this.absoluteTargetPosition=" + this.absoluteTargetPosition));
            FCSLOG.info((Object)("this.handoffPosition=" + this.handoffPosition));
            FCSLOG.info((Object)("this.atHandoff=" + this.atHandoff));
            throw new FailedCommandException(this.name + ": check with sensors: HANDOFF sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.onlinePosition && !this.atOnline) {
            throw new FailedCommandException(this.name + ": check with sensors: ONLINE sensors don't confirm trucks position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Do homing for both  controllers.")
    public void homing() {
        this.linearRailMasterController.homing();
        this.linearRailSlaveController.homing();
        this.updatePosition();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller.")
    public void updatePosition() {
        this.truckXminus.updatePosition();
        this.truckXplus.updatePosition();
        this.masterPosition = this.truckXminus.getPosition();
        this.slavePosition = this.truckXplus.getPosition();
        this.deltaPosition = this.masterPosition - this.slavePosition;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read position on controllers, compute difference and throw exceptionif difference is > 1000.")
    public void checkDeltaPosition() {
        this.updatePosition();
        if (Math.abs(this.deltaPosition) > 1000) {
            String msg = "Too much difference between trucks position. Alignment of Slave Truck to be done.";
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, msg);
            throw new FcsHardwareException(this.name + ":" + msg);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller and return position.")
    public int readPosition() {
        this.updatePosition();
        return this.masterPosition;
    }

    @Override
    public boolean myDevicesReady() {
        return this.isInitialized();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                return this.linearRailMasterController.isTargetReached() && Math.abs(this.masterPosition - this.absoluteTargetPosition) < this.positionRange;
            }
            case ALIGN_SLAVE: {
                return this.linearRailSlaveController.isTargetReached() && Math.abs(this.deltaPosition) < this.deltaPositionMax;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.linearRailMasterController.checkFault();
            this.linearRailSlaveController.checkFault();
            this.updatePosition();
            FCSLOG.debug((Object)(this.name + " position=" + this.masterPosition));
            this.autochanger.updateStateWithSensors();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> SDO ERROR IN READING TRUCKS CONTROLLER:"), (Throwable)ex);
        }
        catch (SDORequestException ex) {
            FCSLOG.error((Object)(this.name + "=> SDO ERROR IN READING TRUCKS CONTROLLER:"), (Throwable)ex);
        }
        catch (CanOpenCallTimeoutException ex) {
            FCSLOG.error((Object)(this.name + "=> SDO ERROR IN READING TRUCKS CONTROLLERS:CanOpenCallTimeoutException"), (Throwable)ex);
        }
    }

    void updateStateWithSensors(int[] readHexaValues) {
        this.truckXminus.updateStateWithSensors(readHexaValues);
        this.truckXplus.updateStateWithSensors(readHexaValues);
        this.atHandoff = this.truckXminus.isAtHandoff() && this.truckXplus.isAtHandoff();
        this.atOnline = this.truckXminus.isAtOnline() && this.truckXplus.isAtOnline();
        this.atStandby = this.truckXminus.isAtStandby() && this.truckXplus.isAtStandby();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Release slave controller brake.")
    public void releaseBrakeSlave() {
        if (this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER) && !this.linearRailMasterController.isEnabled()) {
            throw new RejectedCommandException(this.name + " couldn't release slave controller brakebecause master controller is disabled and slave controller is in MASTER_ENCODER mode");
        }
        this.linearRailSlaveController.doReleaseBrake();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Release master controller brake.")
    public void releaseBrakeMaster() {
        this.linearRailMasterController.doReleaseBrake();
    }

    public void checkActionCompleted(int waitTime, int period) {
        Runnable checkPosition = () -> {
            this.updateStateWithSensorsToCheckIfActionIsCompleted();
            if (this.isActionCompleted(this.currentAction)) {
                FCSLOG.info((Object)(this.name + " ==> " + (Object)((Object)this.currentAction) + " " + this.absoluteTargetPosition + " position  has been reached."));
                this.cancelCheckPosition();
            } else {
                FCSLOG.info((Object)(this.name + " ==> " + (Object)((Object)this.currentAction) + " " + this.absoluteTargetPosition + " position  not yet reached."));
            }
        };
        this.checkPositionHandle = this.scheduler.scheduleAtFixedRate(checkPosition, waitTime, period, TimeUnit.MILLISECONDS);
    }

    private void cancelCheckPosition() {
        this.checkPositionHandle.cancel(true);
        FCSLOG.debug((Object)" => check position ended");
    }

    private void waitForEndOfMotion(long timeout) {
        FCSLOG.info((Object)(this.name + " BEGIN WAITING FOR END OF MOTION"));
        try {
            this.checkPositionHandle.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException ex) {
            if (this.checkPositionHandle.isDone()) {
                FCSLOG.info((Object)(this.name + " CHECKING POSITION ENDED"));
            } else {
                FCSLOG.error((Object)(this.name + " during action " + (Object)((Object)this.currentAction) + " waiting was cancelled before END of motion " + ex));
            }
        }
        catch (TimeoutException ex) {
            FCSLOG.error((Object)(this.name + this.currentAction.getFailureMsg() + " GOING TO POSITION IS LASTING TOO LONG - timeout=" + timeout), (Throwable)ex);
            throw new FcsHardwareException(this.name + this.currentAction.getFailureMsg() + " motion is lasting too long - timeout " + timeout, ex);
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)(this.name + " interrupted while waiting end of motion during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " interrupted while waiting end of motion during action=" + (Object)((Object)this.currentAction), ex);
        }
        catch (ExecutionException ex) {
            FCSLOG.error((Object)(this.name + " error during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " error during action=" + (Object)((Object)this.currentAction) + ex);
        }
        finally {
            this.cancelCheckPosition();
            FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF MOTION"));
        }
    }

    @Command(type=Command.CommandType.QUERY)
    public void increaseCurrentMonitoring() {
    }

    @Command(type=Command.CommandType.QUERY)
    public void decreaseCurrentMonitoring() {
        this.truckXminus.decreaseCurrentMonitoringSpeed();
        this.truckXplus.decreaseCurrentMonitoringSpeed();
    }

    public StatusDataPublishedByAutoChangerTrucks createStatusDataPublishedByAutoChangerTrucks() {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setMasterPosition(this.masterPosition);
        s.setSlavePosition(this.slavePosition);
        s.setCurrent(this.current);
        s.setSpeed(this.speed);
        s.setHomingDone(this.isHomingDone());
        s.setAtHandoff(this.atHandoff);
        s.setAtOnline(this.atOnline);
        s.setAtStandby(this.atStandby);
        s.setInError(this.isPositionSensorsInError());
        return s;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByAutoChangerTrucks()));
    }
}

