/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerOnlineClamp
extends MobileItemModule
implements MovedByEPOSController,
ControlledBySensors {
    public static final String ONLINE_CLAMP_CONFIG_CATEGORY = "onlineClampCurrent";
    public static final String CURRENT_MONITOR_TASK_NAME = "-monitorCurrent";
    public static final int TIMEOUT_FOR_CLOSING = 15000;
    public static final int TIMEOUT_FOR_OPENING = 15000;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule mainModule;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    private final EPOSControllerWithBrake controller;
    private final ComplementarySensors closeSensors;
    private final ComplementarySensors openSensors;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @ConfigurationParameter(description="current to clamp ONLINE clamp in mA", category="onlineClampCurrent")
    private int currentToClamp = 0;
    @ConfigurationParameter(description="current to open ONLINE clamp in mA", category="onlineClampCurrent")
    private int currentToOpen = 0;
    @ConfigurationParameter(description="current sent to controller in mA", category="onlineClampCurrent")
    private int sentCurrent = 0;
    private int current;
    @ConfigurationParameter(description="increment of current to lock in a current ramp in mA", category="onlineClampCurrent")
    private int incrementCurrentToClamp = 250;
    @ConfigurationParameter(description="increment of current to close clamp in a current ramp in mA", category="onlineClampCurrent")
    private int incrementCurrentToClose = 250;
    @ConfigurationParameter(description="increment of current to open clamp in a current ramp in mA", category="onlineClampCurrent")
    private int incrementCurrentToOpen = 250;
    @ConfigurationParameter(description="initial current to close clamp in a current ramp in mA", category="onlineClampCurrent")
    private int initialCurrentToClose = 0;
    @ConfigurationParameter(description="final current to close clamp in a current ramp in mA", category="onlineClampCurrent")
    private int finalCurrentToClose = 0;
    @ConfigurationParameter(description="wait time for current ramp when closing a clamp, in milliseconds", category="onlineClampCurrent")
    private int waitTimeToClose = 1000;
    @ConfigurationParameter(description="wait time for current ramp when opening a clamp, in milliseconds", category="onlineClampCurrent")
    private int waitTimeToOpen = 1000;
    @ConfigurationParameter(description="max time for current ramp when closing a clamp, in milliseconds", category="onlineClampCurrent")
    private int maxTimeToClose = 2000;
    @ConfigurationParameter(description="max time for current ramp when opening a clamp, in milliseconds", category="onlineClampCurrent")
    private int maxTimeToOpen = 2000;
    @ConfigurationParameter(description="max time for current ramp when locking a clamp, in milliseconds", category="onlineClampCurrent")
    private int maxTimeToLock = 2000;
    @ConfigurationParameter(description="max time for current ramp when unlocking a clamp, in milliseconds", category="onlineClampCurrent")
    private int maxTimeToUnlock = 2000;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile boolean initialized;
    private boolean controllerConfigured = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private ScheduledFuture<?> currentRampHandle;
    private long waitBeginTime = 0L;
    private long waitDuration = 0L;
    private long TEMPO_TO_RELEASE_BRAKE = 500L;

    public AutochangerOnlineClamp(EPOSControllerWithBrake controller, ComplementarySensors closeSensors, ComplementarySensors openSensors) {
        this.controller = controller;
        this.closeSensors = closeSensors;
        this.openSensors = openSensors;
    }

    @ConfigurationParameterChanger
    public void setCurrentToClamp(int currentToClamp) {
        this.currentToClamp = currentToClamp;
    }

    @ConfigurationParameterChanger
    public void setCurrentToOpen(int currentToOpen) {
        this.currentToOpen = currentToOpen;
    }

    @ConfigurationParameterChanger
    public void setInitialCurrentToClose(int initialCurrentToClose) {
        this.initialCurrentToClose = initialCurrentToClose;
    }

    @ConfigurationParameterChanger
    public void setFinalCurrentToClose(int finalCurrentToClose) {
        this.finalCurrentToClose = finalCurrentToClose;
    }

    @ConfigurationParameterChanger
    public void setSentCurrent(int sentCurrent) {
        this.sentCurrent = sentCurrent;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToClamp(int stepHeightAbsValue) {
        FcsUtils.checkPositive(stepHeightAbsValue);
        this.incrementCurrentToClamp = stepHeightAbsValue;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToOpen(int incrementCurrentToOpen) {
        FcsUtils.checkPositive(incrementCurrentToOpen);
        this.incrementCurrentToOpen = incrementCurrentToOpen;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToClose(int incrementCurrentToClose) {
        FcsUtils.checkPositive(incrementCurrentToClose);
        this.incrementCurrentToClose = incrementCurrentToClose;
    }

    @ConfigurationParameterChanger
    public void setWaitTimeToClose(int waitTimeToClose) {
        FcsUtils.checkPositive(waitTimeToClose);
        this.waitTimeToClose = waitTimeToClose;
    }

    @ConfigurationParameterChanger
    public void setWaitTimeToOpen(int waitTimeToOpen) {
        FcsUtils.checkPositive(waitTimeToOpen);
        this.waitTimeToOpen = waitTimeToOpen;
    }

    @ConfigurationParameterChanger
    public void setMaxTimeToClose(int maxTimeToClose) {
        FcsUtils.checkPositive(maxTimeToClose);
        this.maxTimeToClose = maxTimeToClose;
    }

    @ConfigurationParameterChanger
    public void setMaxTimeToOpen(int maxTimeToOpen) {
        FcsUtils.checkPositive(maxTimeToOpen);
        this.maxTimeToOpen = maxTimeToOpen;
    }

    @ConfigurationParameterChanger
    public void setMaxTimeToLock(int maxTimeToLock) {
        FcsUtils.checkPositive(maxTimeToLock);
        this.maxTimeToLock = maxTimeToLock;
    }

    @ConfigurationParameterChanger
    public void setMaxTimeToUnlock(int maxTimeToUnlock) {
        FcsUtils.checkPositive(maxTimeToUnlock);
        this.maxTimeToUnlock = maxTimeToUnlock;
    }

    public int getInitialCurrentToClose() {
        return this.initialCurrentToClose;
    }

    public int getFinalCurrentToClose() {
        return this.finalCurrentToClose;
    }

    public int getIncrementCurrentToOpen() {
        return this.incrementCurrentToClose;
    }

    public int getIncrementCurrentToClamp() {
        return this.incrementCurrentToClamp;
    }

    public int getIncrementCurrentToClose() {
        return this.incrementCurrentToClose;
    }

    public int getMaxTimeToClose() {
        return this.maxTimeToClose;
    }

    public int getWaitTimeToClose() {
        return this.waitTimeToClose;
    }

    public int getMaxTimeToOpen() {
        return this.maxTimeToOpen;
    }

    public int getMaxTimeToLock() {
        return this.maxTimeToLock;
    }

    public int getMaxTimeToUnlock() {
        return this.maxTimeToUnlock;
    }

    public int getWaitTimeToOpen() {
        return this.waitTimeToOpen;
    }

    public int getSentCurrent() {
        return this.sentCurrent;
    }

    public EPOSControllerWithBrake getController() {
        return this.controller;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public ComplementarySensors getCloseSensors() {
        return this.closeSensors;
    }

    public ComplementarySensors getOpenSensors() {
        return this.openSensors;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockSensor and lockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isCloseSensorsInError() {
        return this.closeSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if unlockSensor and unlockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isOpenSensorsInError() {
        return this.openSensors.isInError();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that closeSensor or openSensor is in ERROR or thatopenSensor and closeSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=CLOSED. Doesn't read again sensors.")
    public boolean isClosed() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED. Doesn't read again sensors.")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=OPENED. Doesn't read again sensors.")
    public boolean isOpened() {
        return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=INTRAVEL. Doesn't read again sensors.")
    public boolean isInTravel() {
        return this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is in fault. Doesn't read controller CPU.")
    public boolean isControllerInFault() {
        return this.controller.isInError();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns controller name.")
    public String getControllerName() {
        return this.controller.getName();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is initialized : controller is booted, parameters in the controller CPU have been opened and controller is configured.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public void init() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name + CURRENT_MONITOR_TASK_NAME, this::monitorCurrent).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofSeconds(60L)));
    }

    public void increaseCurrentMonitoringSpeed() {
        this.periodicTaskService.setPeriodicTaskPeriod(this.name + CURRENT_MONITOR_TASK_NAME, Duration.ofSeconds(30L));
    }

    public void decreaseCurrentMonitoringSpeed() {
        this.periodicTaskService.setPeriodicTaskPeriod(this.name + CURRENT_MONITOR_TASK_NAME, Duration.ofSeconds(60L));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is initialized and configured.")
    public boolean myDevicesReady() {
        return this.mainModule.allDevicesBooted() && this.controller.isInitialized() && this.controllerConfigured;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForOpening() {
        this.autochanger.checkConditionsForActioningOnlineClamps();
        if (!this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " can't be OPENED if autochanger is not HOLDING filter.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForClosing() {
        this.autochanger.checkConditionsForActioningOnlineClamps();
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.controller.isBooted()) {
            this.initializeController();
            this.controller.enable();
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeController() {
        try {
            this.controller.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.controller.getName(), ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read in the CPU of the controller parameters for mode CURRENT.If a parameter has a different value than in configuration, throws an exception.")
    public void enableAndCheckControllerBeforeAction() {
        this.controller.switchOnEnableOperation();
        this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
        try {
            this.controller.checkParameters(EPOSEnumerations.EposMode.CURRENT);
            this.controller.checkFault();
        }
        catch (Exception ex) {
            String msg = this.name + " error in parameters ";
            FCSLOG.error((Object)(msg + ex));
            throw new FcsHardwareException(msg, ex);
        }
        if (!this.controller.isParametersOK()) {
            String msg = this.name + " Some parameter values are not the same in CPU and configuration system.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure controller.")
    public void configureController() {
        try {
            this.controllerConfigured = false;
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
            this.controllerConfigured = true;
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.name, (Throwable)ex);
        }
    }

    @Override
    public void updateCurrent() {
        this.current = this.controller.readCurrent();
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(int[] hexaValues) {
        this.lock.lock();
        try {
            boolean inError;
            this.updatingState = true;
            this.closeSensors.updateValue(hexaValues);
            this.openSensors.updateValue(hexaValues);
            boolean closed = this.closeSensors.isOn();
            boolean opened = this.openSensors.isOn();
            boolean someSensorsInError = this.closeSensors.isInError() || this.openSensors.isInError();
            boolean bl = inError = someSensorsInError || closed && opened;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (closed ? FcsEnumerations.LockStatus.CLOSED : (opened ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
            if (closed && this.sentCurrent == this.currentToClamp) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
        if (this.currentAction == FcsEnumerations.MobileItemAction.SEND_CURRENT_AND_WAIT) {
            this.waitDuration = System.currentTimeMillis() - this.waitBeginTime;
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP || action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
            return this.sentCurrent == this.finalCurrentToClose;
        }
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP) {
            return this.isOpened();
        }
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            return this.isLocked();
        }
        if (action == FcsEnumerations.MobileItemAction.SEND_CURRENT_AND_WAIT) {
            return this.waitDuration > this.TEMPO_TO_RELEASE_BRAKE;
        }
        throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + (Object)((Object)action));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes the ONLINE clamp.", timeout=15000)
    public void close() {
        this.updateStateAndCheckSensors();
        if (this.isOpened() || this.isInTravel()) {
            this.checkConditionsForClosing();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP, 15000L);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be OPENED before a close action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes the ONLINE clamp softly with new parameters and saves the new parameters.", timeout=15000)
    public void closeSoftly(int initialCurrent, int finalCurrent, int incrementCurrent, int waitTime, int maxTime) {
        this.enableAndCheckControllerBeforeAction();
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.checkArguments(initialCurrent, finalCurrent, incrementCurrent, maxTime, "closeSoftly");
        this.setInitialCurrentToClose(initialCurrent);
        this.setFinalCurrentToClose(finalCurrent);
        this.setIncrementCurrentToClose(incrementCurrent);
        this.setWaitTimeToClose(waitTime);
        this.setMaxTimeToClose(maxTime);
        this.controller.doReleaseBrake();
        this.sendCurrentToControllerAndSaveValue(initialCurrent);
        this.executeCurrentRamp(initialCurrent, finalCurrent, incrementCurrent, maxTime, waitTime);
        this.subs.getScheduler().schedule(() -> {
            this.controller.activateBrake();
            this.controller.writeCurrent(0);
        }, 300L, TimeUnit.MILLISECONDS);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open the ONLINE clamp softly with new parameters. Does not save the parameters. To save parameters use change command.", timeout=15000)
    public void openSoftly(int initialCurrent, int finalCurrent, int incrementCurrent, int waitTime, int maxTime) {
        this.enableAndCheckControllerBeforeAction();
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.checkArguments(initialCurrent, finalCurrent, incrementCurrent, maxTime, "openSoftly");
        this.sendCurrentToControllerAndSaveValue(finalCurrent);
        this.controller.doReleaseBrake();
        this.executeCurrentRamp(initialCurrent, finalCurrent, incrementCurrent, maxTime, 0);
        this.subs.getScheduler().schedule(() -> {
            this.controller.activateBrake();
            this.controller.writeCurrent(0);
        }, (long)waitTime, TimeUnit.MILLISECONDS);
    }

    private static int computePeriod(int initialCurrent, int finalCurrent, int incrementCurrent, int maxTime) {
        int nbStep = Math.abs((finalCurrent - initialCurrent) / incrementCurrent);
        return maxTime / nbStep;
    }

    private void checkArguments(int initialCurrent, int finalCurrent, int incrementCurrent, int maxTime, String actionName) {
        AutochangerOnlineClamp.checkCurrentParametersValidity(initialCurrent, finalCurrent, incrementCurrent);
        int nbStep = Math.abs((finalCurrent - initialCurrent) / incrementCurrent);
        if (maxTime % nbStep != 0) {
            throw new IllegalArgumentException(maxTime + " :maxTime has to be a multiple of nbStep. Action= " + actionName + " Clamp= " + this.name + " nbStep= " + nbStep + " = |(finalCurrent - initialCurrent) / incrementCurrent|");
        }
        int period = AutochangerOnlineClamp.computePeriod(initialCurrent, finalCurrent, incrementCurrent, maxTime);
        if (period < 200) {
            int newIncr = Math.abs(200 * (finalCurrent - initialCurrent) / maxTime);
            int newMaxTime = Math.abs(200 * (finalCurrent - initialCurrent) / incrementCurrent);
            throw new IllegalArgumentException(incrementCurrent + " bad value for incrementCurrent => period computed too low= " + period + " incrementCurrent should be > " + newIncr + " or maxTime > " + newMaxTime);
        }
    }

    private static void checkCurrentParametersValidity(int initialCurrent, int finalCurrent, int incrementCurrent) {
        if ((finalCurrent - initialCurrent) % incrementCurrent != 0) {
            throw new IllegalArgumentException("finalCurrent=" + finalCurrent + " initialCurrent=" + initialCurrent + " incrementCurrent=" + incrementCurrent + " (finalCurrent - initialCurrent) has to be a multiple of incrementCurrent");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the ONLINE clamp.", timeout=15000)
    public void open() {
        this.updateStateAndCheckSensors();
        if (this.isClosed() || this.isInTravel()) {
            this.checkConditionsForOpening();
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP, 15000L);
        } else if (this.isOpened()) {
            FCSLOG.info((Object)(this.name + " is already OPENED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be CLOSED before an open action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Locks the ONLINE clamp : sends currentToClamp to the controller with a ramp of currentfrom currentToClose to currentToRamp.", timeout=15000)
    public void lock() {
        this.updateStateAndCheckSensors();
        if (this.isClosed() || this.isInTravel()) {
            this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP, 15000L);
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.name + " is already LOCKED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be CLOSED before lock action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlocks the ONLINE clamp : sends currentToClamp to the controller  with a ramp of current from currentToClamp to currentToClose.", timeout=15000)
    public void unlock() {
        this.updateStateAndCheckSensors();
        if (this.isLocked()) {
            this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP, 15000L);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be LOCKED before unlock action.");
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.enableAndCheckControllerBeforeAction();
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.increaseCurrentMonitoringSpeed();
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP) {
            this.checkArguments(this.initialCurrentToClose, this.finalCurrentToClose, this.incrementCurrentToClose, this.maxTimeToClose, action.name());
            this.controller.doReleaseBrake();
            this.sendCurrentToControllerAndSaveValue(this.initialCurrentToClose);
            this.executeCurrentRamp(this.initialCurrentToClose, this.finalCurrentToClose, this.incrementCurrentToClose, this.maxTimeToClose, this.waitTimeToClose);
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP) {
            this.checkArguments(this.finalCurrentToClose, this.currentToOpen, this.incrementCurrentToOpen, this.maxTimeToOpen, action.name());
            this.sendCurrentToControllerAndSaveValue(this.finalCurrentToClose);
            FcsUtils.sleep(500, this.name);
            this.controller.doReleaseBrake();
            this.executeCurrentRamp(this.finalCurrentToClose, this.currentToOpen, this.incrementCurrentToOpen, this.maxTimeToOpen, 0);
        } else if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            this.checkArguments(this.finalCurrentToClose, this.currentToClamp, this.incrementCurrentToClamp, this.maxTimeToLock, action.name());
            this.sendCurrentToControllerAndSaveValue(this.finalCurrentToClose);
            FcsUtils.sleep(500, this.name);
            this.controller.doReleaseBrake();
            this.executeCurrentRamp(this.finalCurrentToClose, this.currentToClamp, this.incrementCurrentToClamp, this.maxTimeToLock, 0);
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
            this.checkArguments(this.currentToClamp, this.finalCurrentToClose, this.incrementCurrentToClamp, this.maxTimeToUnlock, action.name());
            this.sendCurrentToControllerAndSaveValue(this.currentToClamp);
            FcsUtils.sleep(500, this.name);
            this.controller.doReleaseBrake();
            this.executeCurrentRamp(this.currentToClamp, this.finalCurrentToClose, this.incrementCurrentToClamp, this.maxTimeToUnlock, 0);
        } else {
            throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + (Object)((Object)action));
        }
    }

    @Command(type=Command.CommandType.ACTION, description="sent current to control and save this value")
    public void sendCurrentToControllerAndSaveValue(int current) {
        FCSLOG.finest((Object)(this.name + " current to write to controller " + this.getControllerName() + ":" + current));
        this.controller.writeCurrent((short)current);
        this.getComponentConfigurationEnvironment().change("sentCurrent", (Object)current);
        this.autochanger.saveCurrentSentToOnlineClampsControllers();
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.activateBrake();
        this.controller.writeCurrent(0);
        this.decreaseCurrentMonitoringSpeed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.controller.activateBrake();
        this.controller.writeCurrent(0);
        this.updateStateAndCheckSensors();
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP) {
            if (!this.isClosed()) throw new FailedCommandException(this.name + " is not CLOSED after close command.");
            FCSLOG.info((Object)(this.name + " is CLOSED"));
            return;
        } else {
            if (action != FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) return;
            if (!this.isClosed()) throw new FailedCommandException(this.name + " is not CLOSED after unlock command.");
            FCSLOG.info((Object)(this.name + " has been UNLOCKED and is now CLOSED"));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() {
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, 5);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, 0);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, 35872);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, 48);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() {
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, 0);
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput4, 15);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 32769);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, 0);
    }

    public StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp() {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setName(this.name);
        status.setLockSensorValue(this.closeSensors.isOn());
        status.setUnlockSensorValue(this.openSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorInError(this.closeSensors.isInError());
        status.setUnlockSensorInError(this.openSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        status.setControllerBooted(this.controller.isBooted());
        status.setControllerInFault(this.controller.isInError());
        status.setSentCurrent(this.sentCurrent);
        status.setCurrent(this.current);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByOnlineClamp()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
    }

    private void cancelCurrentRamp() {
        this.currentRampHandle.cancel(true);
        FCSLOG.debug((Object)" => current ramp ended");
    }

    private void waitForEndOfCurrentRamp(int timeout) {
        FCSLOG.info((Object)(this.name + " BEGIN WAITING FOR END OF CURRENT RAMP"));
        try {
            this.currentRampHandle.get(timeout, TimeUnit.SECONDS);
        }
        catch (CancellationException ex) {
            if (this.currentRampHandle.isDone()) {
                FCSLOG.info((Object)(this.name + " CURRENT RAMP ENDED"));
            } else {
                FCSLOG.error((Object)(this.name + " during action " + (Object)((Object)this.currentAction) + " waiting was cancelled before END of CURRENT RAMP " + ex));
            }
        }
        catch (TimeoutException ex) {
            FCSLOG.error((Object)(this.name + " CURRENT RAMP IS DURING TOO LONG - timeout=" + timeout), (Throwable)ex);
            this.cancelCurrentRamp();
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)(this.name + " interrupted while waiting end of current ramp during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " interrupted while waiting end of current ramp during action=" + (Object)((Object)this.currentAction), ex);
        }
        catch (ExecutionException ex) {
            FCSLOG.error((Object)(this.name + " error during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " error during action=" + (Object)((Object)this.currentAction), ex);
        }
        finally {
            FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF CURRENT RAMP"));
        }
    }

    private void writeCurrentRamp(final int initialValue, final int finalValue, final int increment, long period, int waitTime) {
        FCSLOG.debug((Object)"############################");
        FCSLOG.debug((Object)(this.name + "writeCurrentRamp"));
        FCSLOG.debug((Object)("initialValue=" + initialValue));
        FCSLOG.debug((Object)("finalValue=" + finalValue));
        FCSLOG.debug((Object)("|increment|=" + increment));
        FCSLOG.debug((Object)("period=" + period));
        FCSLOG.debug((Object)("waitTime=" + waitTime));
        FCSLOG.debug((Object)"############################");
        Runnable currentRamp = new Runnable(){
            private final int adjustedStepHeight;
            private int newCurrentValue;
            {
                this.adjustedStepHeight = FcsUtils.getSignedStepHeight(initialValue, finalValue, increment);
                this.newCurrentValue = initialValue + this.adjustedStepHeight;
            }

            public boolean finalValueReached() {
                boolean reachedUp = this.adjustedStepHeight > 0 && this.newCurrentValue > finalValue;
                boolean reachedDown = this.adjustedStepHeight < 0 && this.newCurrentValue < finalValue;
                return reachedUp || reachedDown;
            }

            @Override
            public void run() {
                if (this.finalValueReached()) {
                    AutochangerOnlineClamp.this.cancelCurrentRamp();
                } else {
                    AutochangerOnlineClamp.this.sendCurrentToControllerAndSaveValue(this.newCurrentValue);
                    this.newCurrentValue += this.adjustedStepHeight;
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, waitTime, period, TimeUnit.MILLISECONDS);
    }

    public void executeCurrentRamp(int initialCurrent, int finalCurrent, int incrementCurrent, int maxTime, int waitTime) {
        int period = AutochangerOnlineClamp.computePeriod(initialCurrent, finalCurrent, incrementCurrent, maxTime);
        this.writeCurrentRamp(initialCurrent, finalCurrent, incrementCurrent, period, waitTime);
        this.waitForEndOfCurrentRamp(15000);
    }
}

