package autochanger

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.description.groovy.CCSBuilder



def acPlutoGatewayName = "acSensorsGateway" // to monitor the autochanger sensors

CCSBuilder builder = ["autochanger-standalone"]

builder.
    main (AutochangerMainModule, 
    bridge:ref("tcpProxy"), autochanger:ref("autochanger"), inclinometer:ref("inclinometer"))
//begin description of Main submodules
{  
    //-------------------------
    // BEGIN Filter Manager description
    
    filterManager(FilterManager) {//begin description of filter manager's children
        filterU (Filter,filterID:1, weight:38, socketName:"socket1")
        filterG (Filter,filterID:2, weight:33, socketName:"socket2")
        filterR (Filter,filterID:3, weight:30, socketName:"socket3")
        filterI (Filter,filterID:4, weight:28, socketName:"socket4")
        filterZ (Filter,filterID:5, weight:28, socketName:"socket5")
        filterY (Filter,filterID:6, weight:22.5,socketName:"OUT")
        dummyFilter (Filter,filterID:10,weight:44.5,socketName:"OUT")
    }//end description of filter manager's children
    // END Filter Manager description
    // ------------------------------
    
    //-------------------------
    // BEGIN Filter Identificator description
    filterIdentificator(FilterIdentificator,plutoGatewayName: acPlutoGatewayName)
    {//begin description of filter Identificator's children
        filterIDSensor0 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:0,byteNumero:4)
        
        filterIDSensor1 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:1,byteNumero:4)
        
        filterIDSensor2 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:2,byteNumero:4)
        
        filterIDSensor3 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:3,byteNumero:4)
        
        filterIDSensor4 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:4,byteNumero:4)
        
        filterIDSensor5 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:5,byteNumero:4)
    }//end description of filter identificator's children
    // END Filter Identificator description
    // tcp Proxy
    tcpProxy (CanOpenProxy,
        portNumber:50000,fieldBusTimeout:2000,clientName:"TestBench",
        hardwareBootTimeout:1000
    ) {
        
        // can open devices
        //sensors gateway
        "$acPlutoGatewayName" (CanOpenPlutoGateway,
            nodeID:"3a",serialNB:"3269",station_addr:"01")
        
        brakeSystemGateway (CanOpenPlutoGateway,
            nodeID:"2b",serialNB:"2071",station_addr:"01")
        
        // can open devices
        linearRailMasterController (CanOpenEPOS, 
            nodeID:"2a",serialNB:"80001881",
            paramsForCurrent:[
                MotorType:10, PositionSensorType:260,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,
                MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition:[
                ProfileAcceleration:1207, ProfileDeceleration:1207,
                MaxProfileVelocity:322, QuickStopDeceleration:1207,
                MaxFollowingError:200000,//on verra plus tard
                ProfileVelocity:281,MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]
        )

        // can open devices
        linearRailSlaveController (CanOpenEPOS, 
            nodeID:"2c",serialNB:"80001932",
            paramsForCurrent:[
                MotorType:10, PositionSensorType:1,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition: [
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:30000,
                MaxFollowingError:7000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])

        latchXminusController (CanOpenEPOS,  //CanOpenEPOS24-3
            nodeID:"f",serialNB:"84004735",
            paramsForCurrent: [
                ContinuousCurrentLimit:400,OutputCurrentLimit:400],
            paramsForProfilePosition: [MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]
        )

        // can open devices
        latchXplusController (CanOpenEPOS,  //CanOpenEPOS24-3
            nodeID:"e", serialNB:"84004711",
            paramsForCurrent: [
                MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,
                MaxSpeedInCurrentMode:100],
            paramsForProfilePosition: [MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]
        )

        // can open devices
        onlineClampXminusController (CanOpenEPOS, 
            nodeID:"31",serialNB:"79011618",
            paramsForCurrent: 
            [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:419, //160?
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0],
        )
        // can open devices
        onlineClampXplusController (CanOpenEPOS, 
            nodeID:"30", serialNB:"79011616",
            paramsForCurrent: 
            [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:419, //160?
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0],
        )
        // can open devices
        onlineClampYminusController (CanOpenEPOS, 
            nodeID:"32", serialNB:"79011243",
            paramsForCurrent: 
            [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:419, //160?
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0],
        )
    //************************************//            
    }//end description of bridge's children
    //************************************//
    //**************************************************************************//
    // end of Bridge
    //**************************************************************************//
    
    inclinometer (InclinometerModule, plutoGatewayName:acPlutoGatewayName)
    
    /**********************************************************************/
    /*                FAKE CAROUSEL DESCRIPTION                       */
    /**********************************************************************/
    //in the autochanger standalone subsystem the fake carousel is a switch which
    //simulates that carousel holds a filter at STANDBY 
    
    carousel(FakeFilterHolder,
        plutoGatewayName:acPlutoGatewayName, 
        holdingFilterSensor0:ref("carouselHoldingFilterSensor0"),
        holdingFilterSensor1:ref("carouselHoldingFilterSensor1"),
    )
    {//begin description of fakeCarousel's children 
        carouselHoldingFilterSensor0(CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:6,byteNumero:3)
        carouselHoldingFilterSensor1(CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:7,byteNumero:3)        
    }//end description of fakeCarousel's children
    
        /**********************************************************************/
        /*                END of FAKE CAROUSEL DESCRIPTION                 */
        /**********************************************************************/

        /**********************************************************************/
        /*                FAKE LOADER DESCRIPTION                       */
        /**********************************************************************/
        //in the autochanger standalone subsystem the fake loader is couple of complementary sensors
        //simulate that loader holds a filter at HANDOFF 

    loader(FakeFilterHolder, plutoGatewayName:acPlutoGatewayName, 
        holdingFilterSensor0:ref("loaderHoldingFilterSensor0"),
        holdingFilterSensor1:ref("loaderHoldingFilterSensor1"),
    )
    {//begin description of fakeAutochanger's children 
        loaderHoldingFilterSensor0(CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:6, byteNumero:2)
        loaderHoldingFilterSensor1(CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:7, byteNumero:2)        
    }//end description of fakeLoader's children
    
    /**********************************************************************/
    /*                END of FAKE AUTOCHANGER DESCRIPTION                 */
    /**********************************************************************/
    
    //**************************************************************************//
    //**************************************************************************//
    // autochanger
    //**************************************************************************//
    //**************************************************************************//
    autochanger(AutoChangerModule,
        plutoGatewayName:acPlutoGatewayName,
        loaderConnectedSensor0:ref("loaderConnectedSensor0"),
        loaderConnectedSensor1:ref("loaderConnectedSensor1"),
        trucks:ref("autochangerTrucks"),
        latches:ref("latches"),
        onlineClamps:ref("onlineClamps"))
    {//begin description of autochanger children
        loaderConnectedSensor0 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:4, byteNumero:2)
        loaderConnectedSensor1 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:5, byteNumero:2)
        //**************************************************************************//
        // autochanger trucks description
        //**************************************************************************//
        autochangerTrucks (AutoChangerTwoTrucksModule, 
            truckXminus:ref("acTruckXminus"), truckXplus:ref("acTruckXplus"))
        {//begin description of autochanger trucks children
            acTruckXminus (AutochangerTruckModule, 
                handoffPositionSensor:ref("handoffPositionSensorXminus"),
                handoffPositionSensorB:ref("handoffPositionSensorBXminus"),
                onlinePositionSensor:ref("onlinePositionSensorXminus"),
                onlinePositionSensorB:ref("onlinePositionSensorBXminus"),
                standbyPositionSensor:ref("standbyPositionSensorXminus"),
                standbyPositionSensorB:ref("standbyPositionSensorBXminus"))
            {//begin description of autochanger truckXminus children

                handoffPositionSensorXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:0, byteNumero:1)
                
                handoffPositionSensorBXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:1, byteNumero:1)
                
                onlinePositionSensorXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:2, byteNumero:1)
                
                onlinePositionSensorBXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName,inputNumero:3, byteNumero:1)
                
                standbyPositionSensorXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:6, byteNumero:0)
                
                standbyPositionSensorBXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:7, byteNumero:0)
            }//end description of autochanger acTruckXminus children
            acTruckXplus (AutochangerTruckModule, 
                handoffPositionSensor:ref("handoffPositionSensorXplus"),
                handoffPositionSensorB:ref("handoffPositionSensorBXplus"),
                onlinePositionSensor:ref("onlinePositionSensorXplus"),
                onlinePositionSensorB:ref("onlinePositionSensorBXplus"),
                standbyPositionSensor:ref("standbyPositionSensorXplus"),
                standbyPositionSensorB:ref("standbyPositionSensorBXplus"))
            {//begin description of autochanger truckXplus children
                handoffPositionSensorXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero: 0, byteNumero:9)                                    
                handoffPositionSensorBXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:1, byteNumero:9)
                onlinePositionSensorXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:2, byteNumero:9)
                onlinePositionSensorBXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:3, byteNumero:9)
                standbyPositionSensorXplus( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:6, byteNumero:8)
                standbyPositionSensorBXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:7, byteNumero:8)
            }//end description of autochanger acTruckXplus children
            
        }//end description of autochanger trucks children            
        //**************************************************************************//
        // end of autochanger trucks description
        //**************************************************************************//
        
        //**************************************************************************//
        // autochanger latches description
        //**************************************************************************//
        latches (AutochangerTwoLatches, latchXminus:ref("latchXminus"), latchXplus:ref("latchXplus"))
        {//begin description of autochanger latches children
            //*************************************//
            // autochanger latchXminus description
            //*************************************//
            latchXminus (AutochangerLatchModule,
                latchController:ref("latchXminusController"),
                lockSensors:ref("lockSensorsLatchXminus"),
                unlockSensors:ref("unlockSensorsLatchXminus"),
                filterEngagedSensors:ref("filterEngagedSensorsLatchXminus"),
            )
            {//begin description of autochanger latchXminus children
                lockSensorsLatchXminus ( ComplementarySensors,
                    sensor:ref("lockSensorLatchXminus"),
                    sensorC:ref("lockSensorBLatchXminus")
                )
                {//begin description of autochanger lockSensorslatchXminus children
                    lockSensorLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:2, byteNumero:0)
                    lockSensorBLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:3, byteNumero:0)
                }//end description of autochanger lockSensorslatchXminus children
                
                unlockSensorsLatchXminus ( ComplementarySensors,
                    sensor:ref("unlockSensorLatchXminus"),
                    sensorC:ref("unlockSensorBLatchXminus")
                )     
                {//begin description of autochanger unlockSensorslatchXminus children
                    unlockSensorLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:0, byteNumero:0)
                    unlockSensorBLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:1, byteNumero:0)
                }//end description of autochanger unlockSensorslatchXminus children

                filterEngagedSensorsLatchXminus ( ComplementarySensors,
                    sensor:ref("filterEngagedSensorLatchXminus"),
                    sensorC:ref("filterEngagedSensorBLatchXminus")
                )
                {//begin description of autochanger filterEngagedSensorslatchXminus children
                    filterEngagedSensorLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:4, byteNumero:0)
                    filterEngagedSensorBLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:5, byteNumero:0)
                }//end description of autochanger filterEngagedSensorslatchXminus children

            }//end description of autochanger latchXminus children
            //**********************************************//
            // end of autochanger latchXminus description   //
            //**********************************************//
            //*************************************//
            // autochanger latchXplus description
            //*************************************//
            latchXplus (AutochangerLatchModule,
                latchController:ref("latchXplusController"),
                lockSensors:ref("lockSensorsLatchXplus"),
                unlockSensors:ref("unlockSensorsLatchXplus"),
                filterEngagedSensors:ref("filterEngagedSensorsLatchXplus"),
            )
            {//begin description of autochanger latchXplus children
                lockSensorsLatchXplus ( ComplementarySensors,
                    sensor:ref("lockSensorLatchXplus"),
                    sensorC:ref("lockSensorBLatchXplus")
                )
                {//begin description of autochanger lockSensorslatchXplus children
                    lockSensorLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:2, byteNumero:8)
                    lockSensorBLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:3, byteNumero:8)
                }//end description of autochanger lockSensorslatchXplus children
                
                unlockSensorsLatchXplus ( ComplementarySensors,
                    sensor:ref("unlockSensorLatchXplus"),
                    sensorC:ref("unlockSensorBLatchXplus")
                )     
                {//begin description of autochanger unlockSensorslatchXplus children
                    unlockSensorLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:0, byteNumero:8)
                    unlockSensorBLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:1, byteNumero:8)
                }//end description of autochanger unlockSensorslatchXplus children

                filterEngagedSensorsLatchXplus ( ComplementarySensors,
                    sensor:ref("filterEngagedSensorLatchXplus"),
                    sensorC:ref("filterEngagedSensorBLatchXplus")
                )
                {//begin description of autochanger filterEngagedSensorslatchXplus children
                    filterEngagedSensorLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:4, byteNumero:8)
                    filterEngagedSensorBLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:5, byteNumero:8)
                }//end description of autochanger filterEngagedSensorslatchXplus children

            }//end description of autochanger latchXplus children
            //**********************************************//
            // end of autochanger latchXplus description   //
            //**********************************************//
        }//end description of autochanger latches children
        //*****************************************************************************//
        // end of autochanger latches description
        //*****************************************************************************//
        
        //**************************************************************************//
        //**************************************************************************//
        // autochanger onlineClamps description
        //**************************************************************************//
        //**************************************************************************//
        onlineClamps (AutochangerThreeOnlineClamps, 
            onlineClampXminus:ref("onlineClampXminus"), 
            onlineClampXplus:ref("onlineClampXplus"), 
            onlineClampY:ref("onlineClampYminus")) 
        {//begin description of autochanger onlineClamps children
            
            onlineClampXminus(AutochangerOnlineClampModule ,
                controller:ref("onlineClampXminusController"),
                closeSensor:ref("onlineClampXminusCloseSensor"),
                closeSensorC:ref("onlineClampXminusCloseSensorC"),
                openSensor:ref("onlineClampXminusOpenSensor"),
                openSensorC:ref("onlineClampXminusOpenSensorC"),
                currentToClose:-350,
                currentToClamp:-3000,
            )
            {//begin description of autochanger onlineClampXminus children
                onlineClampXminusCloseSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 6, byteNumero: 1)
                onlineClampXminusCloseSensorC ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 7, byteNumero: 1)
                onlineClampXminusOpenSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 4, byteNumero: 1)
                onlineClampXminusOpenSensorC ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 5, byteNumero: 1)
            }//end of  description of autochanger onlineClampXminus children
            
            onlineClampXplus(AutochangerOnlineClampModule ,
                controller:ref("onlineClampXplusController"),
                closeSensor:ref("onlineClampXplusCloseSensor"),
                closeSensorC:ref("onlineClampXplusCloseSensorC"),
                openSensor:ref("onlineClampXplusOpenSensor"),
                openSensorC:ref("onlineClampXplusOpenSensorC"),
                currentToClose:300,
                currentToClamp:3000,
            )
            {//begin description of autochanger onlineClampXplus children
                onlineClampXplusCloseSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 6, byteNumero: 9)
                onlineClampXplusCloseSensorC ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 7, byteNumero: 9)
                onlineClampXplusOpenSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName,inputNumero: 4, byteNumero: 9)
                onlineClampXplusOpenSensorC ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 5, byteNumero: 9)
            }//end of  description of autochanger onlineClampXplus children
            
            onlineClampYminus(AutochangerOnlineClampModule ,
                controller:ref("onlineClampYminusController"),
                closeSensor:ref("onlineClampYminusCloseSensor"),
                closeSensorC:ref("onlineClampYminusCloseSensorC"),
                openSensor:ref("onlineClampYminusOpenSensor"),
                openSensorC:ref("onlineClampYminusOpenSensorC"),
                currentToClose:-700,
                currentToClamp:-4000,
            )
            {//begin description of autochanger onlineClampYminus children
                onlineClampYminusCloseSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 2, byteNumero: 2)
                onlineClampYminusCloseSensorC ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 3, byteNumero: 2)
                onlineClampYminusOpenSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 0, byteNumero: 2)
                onlineClampYminusOpenSensorC ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 1, byteNumero: 2)
            }//end of  description of autochanger onlineClampYminus children
        }//end of  description of autochanger onlineClamps children
        //**************************************************************************//
        // end of autochanger onlineClamps description
        //**************************************************************************//
        
    }//end description of autochanger children
    //*****************************************************************************//
    //*****************************************************************************//
    // end of autochanger description
    //*****************************************************************************//
    //*****************************************************************************//
    
}    // main
