/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftFilterLatchModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.TruckModule;

public class SftAutoChangerModule
extends BasicAutoChangerModule {
    protected SftTruckMotor sftTrucksMotor;
    private final long timeToConfortAPosition = 2000L;
    private final long timeToGoToStandby = 10000L;
    private final long timeToGoToStandback = 10000L;

    public SftAutoChangerModule(SftFilterLatchModule latchXminus, SftFilterLatchModule latchXplus, TruckModule truckXminus, TruckModule truckXplus, String railsSensorsDIOName, String filterSensorsDIOName, SftTruckMotor sftTrucksMotor) {
        super(latchXminus, latchXplus, truckXminus, truckXplus, railsSensorsDIOName, filterSensorsDIOName);
        this.sftTrucksMotor = sftTrucksMotor;
    }

    public SftTruckMotor getSftTrucksMotor() {
        return this.sftTrucksMotor;
    }

    public long getTimeToConfortAPosition() {
        return 2000L;
    }

    public long getTimeToGoToStandback() {
        return 10000L;
    }

    public long getTimeToGoToStandby() {
        return 10000L;
    }

    @Override
    public boolean isMovingToStandback() {
        return this.sftTrucksMotor.isMovingToStandback();
    }

    @Override
    public boolean isMovingToStandby() {
        return this.sftTrucksMotor.isMovingToStandby();
    }

    @Override
    public boolean isMoving() {
        return this.isMovingToStandback() || this.isMovingToStandby();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void locateTrucks() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Command(level=1, description="Go to STANDBACK", type=Command.CommandType.ACTION)
    public String goToStandback() {
        this.checkPreConditionsForTrucksMotion();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            return this.getName() + " trucks already at standback location";
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.ERROR)) {
            FCSLOG.error((Object)(this.getName() + " Cannot execute goToStandback : ERROR in reading rails sensors"));
            throw new RejectedCommandException(this.getName() + " Cannot execute goToStandback : ERROR in reading rails sensors.");
        }
        if (this.isAtStandby()) {
            if (!this.isTrucksEmpty() && this.getLatchesState() == FcsEnumerations.LockStatus.LOCKED) {
                this.carousel.updateClampsStateWithSensors();
                if (this.carousel.isHoldingFilterAtStandby()) {
                    throw new RejectedCommandException(this.getName() + " can't move filter to standback because the carousel is holding the filter at standby.");
                }
            }
            FCSLOG.debug((Object)(this.getName() + ": The position is being conforted"));
            this.sftTrucksMotor.moveToStandby();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                FCSLOG.debug((Object)ex);
            }
        }
        FCSLOG.info((Object)(this.getName() + " IS GOING TO STANDBACK POSITION"));
        this.sftTrucksMotor.moveToStandback();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            FCSLOG.debug((Object)ex);
        }
        this.sftTrucksMotor.off();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            FCSLOG.debug((Object)("====> " + this.getName() + "  IS AT STANDBACK POSITION"));
            return this.getName() + " IS AT STANDBACK POSITION";
        }
        throw new FailedCommandException(this.getName() + "could not go to STANDBACK POSITION");
    }

    @Override
    @Command(level=1, description="Go to STANDBY.", type=Command.CommandType.ACTION)
    public String goToStandby() {
        this.checkPreConditionsForTrucksMotion();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandby()) {
            return this.getName() + "trucks already at standby position";
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN)) {
            FCSLOG.error((Object)(this.getName() + " Cannot execute goToStandby : Trucks are between standback and standby location."));
            throw new RejectedCommandException(this.getName() + " Cannot execute goToStandby : Trucks are between standback and standby location.");
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.ERROR)) {
            FCSLOG.error((Object)(this.getName() + " Cannot execute goToStandby : ERROR in reading rails sensors"));
            throw new RejectedCommandException(this.getName() + " Cannot execute goToStandby : ERROR in reading rails sensors.");
        }
        if (this.isAtStandback()) {
            this.sftTrucksMotor.moveToStandback();
            try {
                FCSLOG.debug((Object)(this.getName() + ": Waiting for the position to be conforted"));
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                FCSLOG.error((Object)ex);
            }
        }
        FCSLOG.info((Object)(this.getName() + " IS GOING TO STANDBY POSITION"));
        this.sftTrucksMotor.moveToStandby();
        try {
            FCSLOG.debug((Object)(this.getName() + ": Waiting for the trucks to go to STANDBY"));
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)ex);
        }
        this.sftTrucksMotor.off();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandby()) {
            FCSLOG.debug((Object)("====> " + this.getName() + "  IS AT STANDBY POSITION"));
            return this.getName() + " IS AT STANDBY POSITION";
        }
        throw new FailedCommandException(this.getName() + " could not go to STANDBY POSITION");
    }

    @Override
    public String moveFilterToStandback(Filter aFilter) {
        if (this.isTrucksEmpty()) {
            throw new RejectedCommandException(this.getName() + " unable to moveFilterToStandback: Autochanger is empty");
        }
        this.goToStandback();
        this.updateLatchesStateWithSensors();
        this.publishDataAndNotifyObservers();
        return this.getName() + ": " + aFilter.getName() + " is at standback position.";
    }

    @Override
    public String moveFilterToStandby(Filter aFilter) {
        if (this.isTrucksEmpty()) {
            throw new RejectedCommandException(this.getName() + "/moveFilterToStandby: Autochanger is empty");
        }
        this.carousel.updateClampsStateWithSensors();
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new RejectedCommandException(this.getName() + "can't move a filter to STANDBY because carousel is not ready to grab a filter.");
        }
        this.goToStandby();
        this.updateLatchesStateWithSensors();
        this.publishDataAndNotifyObservers();
        return this.getName() + ": " + aFilter.getName() + " is at standby position.";
    }

    @Override
    @Command(level=1, description="Read sensors and update latches and trucks state", type=Command.CommandType.QUERY)
    public void updateStateWithSensors() {
        this.updateLatchesStateWithSensors();
        this.updateTrucksLocationWithSensors();
        this.publishData();
        if (this.getLatchXminus().getPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.NOFILTER) && this.getLatchXplus().getPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.NOFILTER)) {
            this.setTrucksEmpty(true);
            this.setFilterOnTrucks(null);
        }
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

