/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuPlutoGateway
extends PlutoGatewayModule {
    public SimuPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        for (int i = 0; i < this.hexaValues.length; ++i) {
            this.hexaValues[i] = "00";
        }
    }

    @Override
    public int readNewAnalogValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] readNewHexaValues() {
        return this.hexaValues;
    }

    @Override
    public String[] readHexaValuesFromPDO() {
        return this.hexaValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDigitalValues(CanOpenNumericSensor sensor, String digitalValue) {
        this.lock.lock();
        try {
            this.updatingValues = true;
            int byteNo = sensor.getByteNumero();
            FCSCst.FCSLOG.finest((Object)(this.getName() + "=> old hexa value = " + this.hexaValues[byteNo]));
            StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValues[byteNo]));
            bin.replace(7 - sensor.getInputNumero(), 7 - sensor.getInputNumero() + 1, digitalValue);
            String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
            FCSCst.FCSLOG.finest((Object)(this.getName() + "=> new hexa value =" + newDIOHexaValue));
            this.hexaValues[byteNo] = newDIOHexaValue;
            FCSCst.FCSLOG.finest((Object)(this.getName() + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0] + " hexaValues[1]=" + this.hexaValues[1]));
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }
}

