/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderClampController
extends SimuEPOSControllerModule {
    private LoaderClampModule clamp;
    private SimuLoaderPlutoGateway plutoGateway;
    private final String plutoGatewayName;

    public SimuLoaderClampController(String nodeID, String serialNB, String plutoGatewayName, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.plutoGatewayName = plutoGatewayName;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.clamp = (LoaderClampModule)lookup.getComponentByName("clamp");
        this.plutoGateway = (SimuLoaderPlutoGateway)lookup.getComponentByName(this.plutoGatewayName);
    }

    @Override
    public void writeCurrent(int aValue) {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        FCSCst.FCSLOG.debug((Object)("=>initial current=" + this.actualCurrent));
        int stepsNB = 10;
        int step = (this.targetCurrent - this.actualCurrent) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            this.actualCurrent = currentInitial + i * step;
            this.clamp.updateCurrent();
            if (this.actualCurrent == this.clamp.getCurrentToClamp()) {
                FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                this.position = this.clamp.getTargetPositionToClamp();
                this.plutoGateway.simulateLoaderClampIsLocked();
            } else if (this.actualCurrent == this.clamp.getCurrentToGoHome()) {
                this.position = this.clamp.getTargetPositionToOpen();
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            }
            this.clamp.publishData();
            FCSCst.FCSLOG.debug((Object)("i=" + i + ",actualCurrent=" + this.actualCurrent));
            try {
                Thread.sleep(500L);
                if (!this.clamp.getHaltRequired().get()) continue;
                FCSCst.FCSLOG.debug((Object)(this.getName() + " STOP simulated clamp motion."));
                return;
            }
            catch (InterruptedException ex) {
                throw new FcsHardwareException(this.getName() + " sleep was interrupted.", (Throwable)ex);
            }
        }
        this.actualCurrent = aValue;
        if (this.actualCurrent == this.clamp.getCurrentToClamp()) {
            FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.position = this.clamp.getTargetPositionToClamp();
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else if (this.actualCurrent == this.clamp.getCurrentToGoHome()) {
            this.position = this.clamp.getTargetPositionToOpen();
            this.plutoGateway.simulateLoaderClampIsUnLocked();
        }
        this.clamp.publishData();
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.debug((Object)("=>position intitiale=" + this.position));
        int stepsNB = 10;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            this.position = positionInitiale + i * step;
            this.clamp.updatePosition();
            if (this.position == this.clamp.getTargetPositionToOpen()) {
                FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            } else if (this.position == this.clamp.getTargetPositionToClose() || this.position == this.clamp.getTargetPositionToClamp()) {
                this.plutoGateway.simulateLoaderClampIsLocked();
            } else {
                this.plutoGateway.simulateLoaderClampIsInTravel();
            }
            this.clamp.publishData();
            FCSCst.FCSLOG.debug((Object)("i=" + i + ",position=" + this.position));
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ex) {
                throw new RejectedCommandException(this.getName() + " sleep was interrupted.");
            }
        }
        this.position = this.targetPosition;
        if (this.position == this.clamp.getTargetPositionToOpen()) {
            FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.plutoGateway.simulateLoaderClampIsUnLocked();
        } else if (this.position == this.clamp.getTargetPositionToClose()) {
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else if (this.position == this.clamp.getTargetPositionToClamp()) {
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else {
            this.plutoGateway.simulateLoaderClampIsInTravel();
        }
        this.clamp.publishData();
    }
}

