/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuCarouselController
extends SimuEPOSControllerModule {
    private CarouselModule carousel;

    public SimuCarouselController(String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (CarouselModule)this.getComponentLookup().getComponentByName("carousel");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods start the motion to the targetPosition.")
    public void writeControlWord(String controlWord) {
        if (controlWord.equals("3F")) {
            this.simulateWriteTargetPosition(this.targetPosition, this.position);
        } else if (controlWord.equals("7F")) {
            int positionToReach = FcsUtils.addAngle(this.targetPosition, this.position);
            int positionInitiale = this.position;
            if (0 <= this.targetPosition && this.targetPosition < 180 && positionToReach < this.position) {
                positionToReach += 360;
            } else if (-180 < this.targetPosition && this.targetPosition <= 0 && positionToReach > this.position) {
                positionInitiale += 360;
            }
            this.simulateWriteTargetPosition(positionToReach, positionInitiale);
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int position) throws FcsHardwareException {
        this.targetPosition = position;
    }

    public void simulateWriteTargetPosition(int positionToReach, int positionInitiale) {
        FCSCst.FCSLOG.fine((Object)(this.getName() + " positionToReach=" + positionToReach));
        this.targetPosition = positionToReach;
        FCSCst.FCSLOG.fine((Object)(this.getName() + "=> carousel is rotating."));
        FCSCst.FCSLOG.fine((Object)(this.getName() + "=> position initiale=" + this.position));
        FCSCst.FCSLOG.fine((Object)(this.getName() + "=> target position=" + this.targetPosition));
        int stepsNB = 10;
        int step = (this.targetPosition - positionInitiale) / stepsNB;
        try {
            for (int i = 1; i < stepsNB; ++i) {
                this.position = positionInitiale + i * step;
                this.carousel.updatePosition();
                FCSCst.FCSLOG.fine((Object)(this.getName() + " i=" + i + ",position=" + this.position));
                try {
                    Thread.sleep(500L);
                    if (!this.carousel.getHaltRequired().get()) continue;
                    FCSCst.FCSLOG.fine((Object)(this.getName() + " STOP simulated carousel motion."));
                    return;
                }
                catch (InterruptedException ex) {
                    throw new FcsHardwareException(this.getName() + " sleep was interrupted.", (Throwable)ex);
                }
            }
            this.position = this.targetPosition % 360;
            this.carousel.updatePosition();
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.error((Object)(this.getName() + " should not raise an Exception:"), (Throwable)ex);
        }
    }
}

