/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.Observable;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenProxy;

public class SimuCanOpenSensor14bits
extends CanOpenSensor14bits {
    protected SimuCanOpenProxy tcpProxy;
    protected CarouselClampModule clamp;
    protected FilterHolder autochanger;
    private CarouselModule carousel;
    private int value1 = 0;
    private int value2 = Short.MAX_VALUE;
    private final SecureRandom randomGenerator = new SecureRandom();
    private SimuAutochangerPlutoGateway acPlutoGateway;

    public SimuCanOpenSensor14bits(String adcName, int numOfAnalogInput) {
        super(adcName, numOfAnalogInput);
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.carousel = (CarouselModule)lookup.getComponentByName("carousel");
        this.clamp = (CarouselClampModule)lookup.getParent(this.getName()).getValue();
        this.tcpProxy = (SimuCanOpenProxy)lookup.getComponentByName("tcpProxy");
        this.tcpProxy.getPdoStorage().setVarValue(this.adc.getNodeID(), Integer.toString(this.numOfAnalogInput), Integer.toHexString(0));
        this.autochanger = (FilterHolder)lookup.getComponentByName("autochanger");
        if (lookup.getComponentByName("acPlutoGateway") != null) {
            this.acPlutoGateway = (SimuAutochangerPlutoGateway)lookup.getComponentByName("acPlutoGateway");
            this.listens(new Observable[]{this.acPlutoGateway});
        } else {
            FCSCst.FCSLOG.warning((Object)"It's normal to have message : null reference associated to acPlutoGateway because in carousel-standalone, a simulated carousel clamp sensor doesn't have to listen to autochanger plutoGateway.");
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + " belongs to clamp " + this.clamp.getName()));
    }

    void setNewRange(int aValue1, int aValue2) {
        if (aValue2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException(this.getName() + "aValue2=" + aValue2 + " Can't be >" + Short.MAX_VALUE);
        }
        if (aValue1 < 0) {
            throw new IllegalArgumentException(this.getName() + " aValue1=" + aValue1 + " Can't be <" + 0);
        }
        if (aValue2 < aValue1) {
            throw new IllegalArgumentException(this.getName() + " aValue1=" + aValue1 + " aValue2=" + aValue2 + "we must have: aValue1<aValue2");
        }
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    @Override
    public int readNewValue() {
        if (this.value2 > 0) {
            int n = this.randomGenerator.nextInt(this.value2);
            if (n > this.value1) {
                return n;
            }
            BigDecimal bd = new BigDecimal(this.value1 + n * (this.value2 - this.value1) / this.value2);
            return bd.intValue();
        }
        String msg = this.getName() + ": ERROR in readNewValue: value2 should be positive";
        throw new IllegalArgumentException(msg);
    }

    protected void updateFakePDOStorage() {
        this.tcpProxy.getPdoStorage().setVarValue(this.adc.getNodeID(), Integer.toString(this.numOfAnalogInput), Integer.toHexString(this.readNewValue()));
    }

    protected boolean isAtStandby() {
        char myNum;
        CarouselSocket socket = this.carousel.getSocketAtStandby();
        if (socket == null) {
            return false;
        }
        String socketName = socket.getName();
        char numSocket = socketName.charAt(socketName.length() - 1);
        return numSocket == (myNum = this.getName().charAt(this.getName().length() - 1));
    }
}

