/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.HardwareException;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

public class SimuCanOpenProxy
extends CanOpenProxy {
    public SimuCanOpenProxy(int portNumber, int fieldBusTimeout, String clientName, long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout, clientName, hardwareBootTimeout);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hardwareBootProcessEnded = true;
    }

    @Override
    public void startServer() {
        this.tcpServerStarted = true;
        this.stopped = false;
    }

    @Override
    public void startThreadReader() {
    }

    @Override
    public void stopServer() {
        this.stopped = true;
        this.tcpServerStarted = false;
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": BEGIN CHECKHARDWARE"));
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HOMING_TO_BE_DONE, FcsEnumerations.FilterReadinessState.NOT_READY});
        for (PieceOfHardware device : this.hardwareMapByNodeID.values()) {
            this.bootedNodes.put(device.getNodeID(), new CanOpenNode(device.getNodeID(), device.getSerialNB()));
            this.publishHardwareData(device);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Override
    public PDOStorage readPDOs() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + "/readPDOS"));
        return this.getPdoStorage();
    }

    @Override
    public boolean isCANDevicesReady() {
        return true;
    }

    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isRealHardware() {
        return false;
    }
}

