/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTruckModule;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLatchController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerOnlineClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterIDPlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuAutochangerPlutoGateway
extends SimuPlutoGateway
implements SimuFilterIDPlutoGatewayInterface {
    private FilterIdentificator filterIdentificator;
    private FilterHolder carousel;
    private AutoChangerModule autochanger;
    private AutoChangerTwoTrucksModule trucks;
    private SimuAutochangerLinearRailController trucksController;
    private SimuAutochangerLinearRailController trucksSlaveController;
    private SimuAutochangerLatchController latchXminusController;
    private SimuAutochangerLatchController latchXplusController;
    private SimuAutochangerOnlineClampController onlineClampXminusController;
    private SimuAutochangerOnlineClampController onlineClampXplusController;
    private SimuAutochangerOnlineClampController onlineClampYminusController;
    private AutochangerTruckModule acTruckXminus;
    private AutochangerTruckModule acTruckXplus;
    private CanOpenNumericSensor loaderConnectedSensor0;
    private CanOpenNumericSensor loaderConnectedSensor1;
    private ComplementarySensors lockSensorsLatchXminus;
    private ComplementarySensors lockSensorsLatchXplus;
    private ComplementarySensors unlockSensorsLatchXminus;
    private ComplementarySensors unlockSensorsLatchXplus;
    private ComplementarySensors filterEngagedSensorsLatchXminus;
    private ComplementarySensors filterEngagedSensorsLatchXplus;
    private CanOpenNumericSensor onlineClampXminusCloseSensor;
    private CanOpenNumericSensor onlineClampXminusCloseSensorC;
    private CanOpenNumericSensor onlineClampXminusOpenSensor;
    private CanOpenNumericSensor onlineClampXminusOpenSensorC;
    private CanOpenNumericSensor onlineClampXplusCloseSensor;
    private CanOpenNumericSensor onlineClampXplusCloseSensorC;
    private CanOpenNumericSensor onlineClampXplusOpenSensor;
    private CanOpenNumericSensor onlineClampXplusOpenSensorC;
    private CanOpenNumericSensor onlineClampYminusCloseSensor;
    private CanOpenNumericSensor onlineClampYminusCloseSensorC;
    private CanOpenNumericSensor onlineClampYminusOpenSensor;
    private CanOpenNumericSensor onlineClampYminusOpenSensorC;

    public SimuAutochangerPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public List<CanOpenNumericSensor> getFilterIDSensors() {
        return this.filterIdentificator.getFilterIDSensors();
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.filterIdentificator = (FilterIdentificator)((Object)lookup.getComponentByName("filterIdentificator"));
        this.carousel = (FilterHolder)lookup.getComponentByName("carousel");
        this.acTruckXminus = (AutochangerTruckModule)lookup.getComponentByName("acTruckXminus");
        this.acTruckXplus = (AutochangerTruckModule)lookup.getComponentByName("acTruckXplus");
        this.loaderConnectedSensor0 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderConnectedSensor0"));
        this.loaderConnectedSensor1 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderConnectedSensor1"));
        this.trucksController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailMasterController");
        this.trucksSlaveController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailSlaveController");
        this.trucks = (AutoChangerTwoTrucksModule)lookup.getComponentByName("autochangerTrucks");
        this.lockSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("lockSensorsLatchXminus");
        this.unlockSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("unlockSensorsLatchXminus");
        this.filterEngagedSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("filterEngagedSensorsLatchXminus");
        this.lockSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("lockSensorsLatchXplus");
        this.unlockSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("unlockSensorsLatchXplus");
        this.filterEngagedSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("filterEngagedSensorsLatchXplus");
        this.latchXminusController = (SimuAutochangerLatchController)lookup.getComponentByName("latchXminusController");
        this.latchXplusController = (SimuAutochangerLatchController)lookup.getComponentByName("latchXplusController");
        this.onlineClampXminusCloseSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXminusCloseSensor"));
        this.onlineClampXminusCloseSensorC = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXminusCloseSensorC"));
        this.onlineClampXminusOpenSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXminusOpenSensor"));
        this.onlineClampXminusOpenSensorC = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXminusOpenSensorC"));
        this.onlineClampXplusCloseSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXplusCloseSensor"));
        this.onlineClampXplusCloseSensorC = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXplusCloseSensorC"));
        this.onlineClampXplusOpenSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXplusOpenSensor"));
        this.onlineClampXplusOpenSensorC = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXplusOpenSensorC"));
        this.onlineClampYminusCloseSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampYminusCloseSensor"));
        this.onlineClampYminusCloseSensorC = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampYminusCloseSensorC"));
        this.onlineClampYminusOpenSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampYminusOpenSensor"));
        this.onlineClampYminusOpenSensorC = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampYminusOpenSensorC"));
        this.simulateAutochangerTrucksIsAtHandoff();
        this.simulateAutochangerIsEmpty();
        this.simulateAutochangerLatchesAreUnlocked();
        this.simulateAutochangerOnlineClampsAreUnlocked();
    }

    protected void simuComplementarySensorsOn(ComplementarySensors sensors) {
        this.replaceDigitalValues((CanOpenNumericSensor)sensors.getSensor(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)sensors.getSensorC(), "0");
    }

    protected void simuComplementarySensorsNotOn(ComplementarySensors sensors) {
        this.replaceDigitalValues((CanOpenNumericSensor)sensors.getSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)sensors.getSensorC(), "1");
    }

    protected void simuComplementarySensorsInError(ComplementarySensors sensors) {
        this.replaceDigitalValues((CanOpenNumericSensor)sensors.getSensor(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)sensors.getSensorC(), "1");
    }

    protected void simulateACTruckIsAtHandoff(AutochangerTruckModule truck) {
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensor(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensorB(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensorB(), "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtHandoff() {
        FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsAtHandoff");
        this.simulateACTruckIsAtHandoff(this.acTruckXminus);
        this.simulateACTruckIsAtHandoff(this.acTruckXplus);
        this.trucksController.setPosition(this.trucks.getHandoffPosition());
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getHandoffPosition());
        this.trucksSlaveController.setPosition(this.trucks.getHandoffPosition());
        this.trucksSlaveController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getHandoffPosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)this.trucks.getHandoffPosition()));
    }

    private void simulateACTruckIsOnline(AutochangerTruckModule truck) {
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensor(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensorB(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensorB(), "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsOnline() {
        this.simulateACTruckIsOnline(this.acTruckXminus);
        this.simulateACTruckIsOnline(this.acTruckXplus);
        this.trucksController.setPosition(this.trucks.getOnlinePosition());
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getOnlinePosition());
        this.trucksSlaveController.setPosition(this.trucks.getOnlinePosition());
        this.trucksSlaveController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getOnlinePosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)this.trucks.getOnlinePosition()));
    }

    private void simulateACTruckIsAtStandby(AutochangerTruckModule truck) {
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensor(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensorB(), "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtStandby() {
        this.simulateACTruckIsAtStandby(this.acTruckXminus);
        this.simulateACTruckIsAtStandby(this.acTruckXplus);
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue());
        this.trucksController.setPosition(this.trucks.getStandbyPosition());
        this.trucksSlaveController.setSsiPosition(this.trucks.getEncoderRibbonMinValue());
        this.trucksSlaveController.setPosition(this.trucks.getStandbyPosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)this.trucks.getStandbyPosition()));
        this.simulateFilterIDAtStandby();
    }

    private void simulateACTruckIsInTravel(AutochangerTruckModule truck) {
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensorB(), "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsInTravel() {
        this.simulateACTruckIsInTravel(this.acTruckXminus);
        this.simulateACTruckIsInTravel(this.acTruckXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "1");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsDisconnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "0");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnAutochanger() {
        this.simuComplementarySensorsOn(this.filterEngagedSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.filterEngagedSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerIsEmpty() {
        this.simuComplementarySensorsNotOn(this.filterEngagedSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.filterEngagedSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreLocked() {
        this.simuComplementarySensorsOn(this.lockSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.lockSensorsLatchXplus);
        this.simuComplementarySensorsNotOn(this.unlockSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.unlockSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreUnlocked() {
        this.simuComplementarySensorsNotOn(this.lockSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.lockSensorsLatchXplus);
        this.simuComplementarySensorsOn(this.unlockSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.unlockSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsLocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsOn(this.lockSensorsLatchXminus);
            this.simuComplementarySensorsNotOn(this.unlockSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsOn(this.lockSensorsLatchXplus);
            this.simuComplementarySensorsNotOn(this.unlockSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsUnlocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsNotOn(this.lockSensorsLatchXminus);
            this.simuComplementarySensorsOn(this.unlockSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsNotOn(this.lockSensorsLatchXplus);
            this.simuComplementarySensorsOn(this.unlockSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLatchLockSensorsInError(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsInError(this.lockSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsInError(this.lockSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreLocked() {
        this.simulateAutochangerOnlineClampXminusIsLocked();
        this.simulateAutochangerOnlineClampXplusIsLocked();
        this.simulateAutochangerOnlineClampYminusIsLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreUnlocked() {
        this.simulateAutochangerOnlineClampXminusIsUnlocked();
        this.simulateAutochangerOnlineClampXplusIsUnlocked();
        this.simulateAutochangerOnlineClampYminusIsUnlocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsLocked(CanOpenNumericSensor lockSensor, CanOpenNumericSensor lockSensorC, CanOpenNumericSensor unlockSensor, CanOpenNumericSensor unlockSensorC) {
        this.replaceDigitalValues(lockSensor, "1");
        this.replaceDigitalValues(lockSensorC, "0");
        this.replaceDigitalValues(unlockSensor, "0");
        this.replaceDigitalValues(unlockSensorC, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsUnlocked(CanOpenNumericSensor lockSensor, CanOpenNumericSensor lockSensorC, CanOpenNumericSensor unlockSensor, CanOpenNumericSensor unlockSensorC) {
        this.replaceDigitalValues(lockSensor, "0");
        this.replaceDigitalValues(lockSensorC, "1");
        this.replaceDigitalValues(unlockSensor, "1");
        this.replaceDigitalValues(unlockSensorC, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXminusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampXminusCloseSensor, this.onlineClampXminusCloseSensorC, this.onlineClampXminusOpenSensor, this.onlineClampXminusOpenSensorC);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXminusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampXminusCloseSensor, this.onlineClampXminusCloseSensorC, this.onlineClampXminusOpenSensor, this.onlineClampXminusOpenSensorC);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXplusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampXplusCloseSensor, this.onlineClampXplusCloseSensorC, this.onlineClampXplusOpenSensor, this.onlineClampXplusOpenSensorC);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXplusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampXplusCloseSensor, this.onlineClampXplusCloseSensorC, this.onlineClampXplusOpenSensor, this.onlineClampXplusOpenSensorC);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampYminusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampYminusCloseSensor, this.onlineClampYminusCloseSensorC, this.onlineClampYminusOpenSensor, this.onlineClampYminusOpenSensorC);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampYminusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampYminusCloseSensor, this.onlineClampYminusCloseSensorC, this.onlineClampYminusOpenSensor, this.onlineClampYminusOpenSensorC);
    }

    private void simulateFilterIDAtStandby() {
        if (this.carousel instanceof CarouselModule && ((CarouselModule)this.carousel).getFilterAtStandby() != null) {
            this.simulateFilterID(((CarouselModule)this.carousel).getFilterAtStandby().getFilterID());
        }
    }

    public void start() {
        boolean aFilterIsOnTrucks = false;
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        FilterManager filterManager = (FilterManager)((Object)this.getComponentLookup().getComponentByName("filterManager"));
        SortedMap<String, Filter> filtersMap = filterManager.getFiltersMapByName();
        for (Map.Entry entry : filtersMap.entrySet()) {
            Filter filter = (Filter)entry.getValue();
            if (!filter.isOnAutoChanger()) continue;
            FCSCst.FCSLOG.fine((Object)(filter.getName() + " is on autochanger trucks."));
            aFilterIsOnTrucks = true;
            this.autochanger.setFilterOnTrucksID(filter.getFilterID());
        }
        if (aFilterIsOnTrucks) {
            this.simulateAutochangerTrucksIsOnline();
            this.simulateFilterIsOnAutochanger();
            this.simulateAutochangerLatchesAreLocked();
            this.simulateAutochangerOnlineClampsAreLocked();
        } else {
            this.simulateAutochangerTrucksIsAtHandoff();
            this.simulateAutochangerIsEmpty();
            this.simulateAutochangerLatchesAreUnlocked();
            this.simulateAutochangerOnlineClampsAreUnlocked();
        }
    }
}

