/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public abstract class PlutoGatewayModule
extends CanOpenDevice
implements PlutoGatewayInterface {
    protected String[] hexaValues;
    protected volatile boolean updatingValues = false;
    protected final Lock lock = new ReentrantLock();
    protected final Condition valueUpdated = this.lock.newCondition();

    public PlutoGatewayModule(String nodeID, String serialNB) {
        super(nodeID, serialNB);
        this.hexaValues = new String[16];
        for (int i = 0; i < this.hexaValues.length; ++i) {
            this.hexaValues[i] = "00";
        }
    }

    @Override
    public String[] getHexaValues() {
        this.lock.lock();
        try {
            while (this.updatingValues) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ex.getMessage()));
                }
            }
            String[] stringArray = this.hexaValues;
            return stringArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateValues() {
        this.lock.lock();
        try {
            this.updatingValues = true;
            this.hexaValues = this.readNewHexaValues();
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signalAll();
            this.lock.unlock();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1)
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (int i = 0; i < this.hexaValues.length; ++i) {
            sb.append("/byte");
            sb.append(i);
            sb.append('=');
            sb.append(String.valueOf(this.hexaValues[i]));
        }
        return sb.toString();
    }
}

