/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenPlutoGateway
extends PlutoGatewayModule {
    @ConfigurationParameter
    private final String station_addr;

    public CanOpenPlutoGateway(String nodeID, String serialNB, String station_addr) {
        super(nodeID, serialNB);
        this.station_addr = station_addr;
    }

    public String getStation_addr() {
        return this.station_addr;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the Gateway.")
    public void initializeAndCheckHardware() {
        this.checkBooted();
        try {
            FCSCst.FCSLOG.info((Object)(this.getName() + " BEGIN initializeHardware"));
            this.configurePlutoForThreeBlocs();
            this.initialized = true;
            FCSCst.FCSLOG.info((Object)(this.getName() + " is INITIALIZED."));
            this.tcpProxy.publishHardwareData(this);
        }
        catch (FailedCommandException | SDORequestException ex) {
            throw new FcsHardwareException(this.getName(), ex);
        }
    }

    @Override
    public void initModule() {
        super.initModule();
        Map.Entry entry = this.getComponentLookup().getParent(this.getName());
        BridgeToHardware bridge = (BridgeToHardware)entry.getValue();
        this.tcpProxy = (CanOpenProxy)bridge;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure this gateway to receive 3 data blocs from Pluto.")
    public void configurePlutoForThreeBlocs() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " configurePlutoForThreeBlocs"));
        this.tcpProxy.writeSDO(this.getNodeID(), "2011", "01", "02", "17");
        this.tcpProxy.writeSDO(this.getNodeID(), "2011", "02", "02", "4");
        this.tcpProxy.writeSDO(this.getNodeID(), "2012", "01", "02", "17");
        this.tcpProxy.writeSDO(this.getNodeID(), "2012", "02", "02", "43");
    }

    public void writeTransmissionType(String transmissionType) {
        String goodAck;
        if (transmissionType == null) {
            throw new IllegalArgumentException(this.getName() + ": Can't write transmission type to device because transmission type is null.");
        }
        String ack = this.tcpProxy.writeSDO(this.getNodeID(), "2005", "1", "1", transmissionType);
        if (!ack.equals(goodAck = "OK")) {
            throw new FailedCommandException(this.getName() + " :bad returned ack for wsdo, index 1801");
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return values in hexa read on the device.")
    public String[] readNewHexaValues() {
        this.checkBooted();
        try {
            this.hexaValues[0] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "01");
            FCSCst.FCSLOG.finest((Object)String.format("%s : first byte read in hexaValue= %s", this.getName(), this.hexaValues[0]));
            this.hexaValues[1] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "02");
            FCSCst.FCSLOG.finest((Object)String.format("%s : second byte read in hexaValue= %s", this.getName(), this.hexaValues[1]));
            this.hexaValues[2] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : third byte read in hexaValue= %s", this.getName(), this.hexaValues[2]));
            this.hexaValues[3] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 4th byte read in hexaValue= %s", this.getName(), this.hexaValues[3]));
            this.hexaValues[4] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "01");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 5th byte read in hexaValue= %s", this.getName(), this.hexaValues[4]));
            this.hexaValues[5] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "02");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 6th byte read in hexaValue= %s", this.getName(), this.hexaValues[5]));
            this.hexaValues[6] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 7th byte read in hexaValue= %s", this.getName(), this.hexaValues[6]));
            this.hexaValues[7] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 8th byte read in hexaValue= %s", this.getName(), this.hexaValues[7]));
            this.hexaValues[8] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "01");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 9th byte read in hexaValue= %s", this.getName(), this.hexaValues[8]));
            this.hexaValues[9] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "02");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 10th byte read in hexaValue= %s", this.getName(), this.hexaValues[9]));
            this.hexaValues[10] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 11th byte read in hexaValue= %s", this.getName(), this.hexaValues[10]));
            this.hexaValues[11] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 12th byte read in hexaValue= %s", this.getName(), this.hexaValues[11]));
            this.hexaValues[12] = this.tcpProxy.readSDO(this.getNodeID(), "6003", "01");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 13th byte read in hexaValue= %s", this.getName(), this.hexaValues[12]));
            this.hexaValues[13] = this.tcpProxy.readSDO(this.getNodeID(), "6003", "02");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 14th byte read in hexaValue= %s", this.getName(), this.hexaValues[13]));
            this.hexaValues[14] = this.tcpProxy.readSDO(this.getNodeID(), "6003", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 15th byte read in hexaValue= %s", this.getName(), this.hexaValues[14]));
            this.hexaValues[15] = this.tcpProxy.readSDO(this.getNodeID(), "6003", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 16th byte read in hexaValue= %s", this.getName(), this.hexaValues[15]));
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING SENSOR:" + (Object)((Object)ex)));
        }
        catch (SDORequestException ex) {
            String message = this.getName() + "=> ERROR IN READING SENSOR:";
            this.raiseAlarm("FCS004:" + this.getName(), message, (Exception)((Object)ex));
        }
        catch (CanOpenCallTimeoutException ex) {
            String msg = this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription() + " to command: readNewHexaValues - POWER FAILURE ? ";
            this.raiseWarning(this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription(), msg + (Object)((Object)ex));
        }
        return this.hexaValues;
    }

    @Override
    public String[] readHexaValuesFromPDO() {
        String[] values = new String[16];
        PDOStorage pdos = this.tcpProxy.readPDOs();
        for (int i = 0; i < 16; ++i) {
            values[i] = pdos.getVarValue(this.nodeID, Integer.toString(i));
        }
        return values;
    }

    @Override
    public int readNewAnalogValue() {
        String hexaL = this.tcpProxy.readSDO(this.getNodeID(), "6001", "01");
        FCSCst.FCSLOG.finest((Object)(this.getName() + ": new analog value in hexa=" + hexaL));
        String hexaM = this.tcpProxy.readSDO(this.getNodeID(), "6001", "02");
        String valueInHexa = hexaM + hexaL;
        FCSCst.FCSLOG.finest((Object)(this.getName() + ": new analog value in hexa=" + valueInHexa));
        int newAnalogValue = Integer.parseInt(valueInHexa, 16);
        FCSCst.FCSLOG.finest((Object)(this.getName() + ": new analog value =" + newAnalogValue));
        return newAnalogValue;
    }
}

