/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.Map;
import java.util.Observable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCanOpenDevice;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class CanOpenDevice
extends Module
implements PieceOfHardware,
AlertRaiser {
    @ConfigurationParameter(isFinal=true, description="serial number of this CANOpen device")
    protected String serialNB;
    @ConfigurationParameter(isFinal=true, description="CANOpen node ID of this CANOpen device")
    protected String nodeID;
    protected CanOpenProxy tcpProxy;
    protected boolean initialized = false;
    protected boolean inError = false;
    protected String[] errorHistory = new String[0];
    protected String errorRegister = "NO ERROR";

    public CanOpenDevice(String nodeID, String serialNB) {
        this.nodeID = nodeID;
        this.serialNB = serialNB;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this CANopen device's serial number.")
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this CANopen device's node ID.")
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this CANopen node is booted.")
    public boolean isBooted() {
        return this.tcpProxy.isBooted(this.nodeID);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this CANopen node is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    public String[] getErrorHistory() {
        if (this.errorHistory == null) {
            return new String[0];
        }
        return (String[])this.errorHistory.clone();
    }

    public String getErrorRegister() {
        return this.errorRegister;
    }

    public boolean isInError() {
        return this.inError;
    }

    public void initModule() {
        Map.Entry entry = this.getComponentLookup().getParent(this.getName());
        this.tcpProxy = (CanOpenProxy)entry.getValue();
        this.initialized = false;
        this.listens(new Observable[]{this.tcpProxy});
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (source instanceof CanOpenProxy && v.getName().equals(this.tcpProxy.getName())) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            if (this.getName().equalsIgnoreCase(emcyMsg.getDeviceName())) {
                FCSCst.FCSLOG.error((Object)(this.getName() + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
                if ("00".equals(emcyMsg.getErrorRegisterCode())) {
                    this.inError = false;
                    this.errorRegister = "NO ERROR";
                    this.errorHistory = new String[0];
                    this.publishData();
                } else {
                    this.inError = true;
                    try {
                        this.errorRegister = emcyMsg.getErrorRegisterName();
                        this.errorHistory = this.readErrorHistoryNames();
                        this.publishData();
                    }
                    catch (FcsHardwareException ex) {
                        this.raiseAlarm("FCS001", "Error on FCS hardware : couldn't read EPOS error register for " + this.name, (Exception)((Object)ex));
                    }
                }
                this.setChanged();
                this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)emcyMsg));
            }
        }
    }

    @Override
    public void initializeAndCheckHardware() {
        this.checkBooted();
        if (this.isBooted()) {
            this.initialized = true;
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Write on the Can Open Device with a command wsdo. All the values are in hexadecimal format. To write new data value in decimal format, please use command writeSDO of tcpProxy.")
    public String writeSDO(String index, String subindex, String size, String newValue) {
        return this.tcpProxy.writeSDO(this.nodeID, index, subindex, size, newValue);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads the Can Open Device with a command rsdo.")
    public String readSDO(String index, String subindex) {
        return this.tcpProxy.readSDO(this.nodeID, index, subindex);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads Error Register on the controller - in hexa (index 1001).")
    public String readErrorRegister() {
        String error = this.readSDO("1001", "0");
        return String.format("%02x", Integer.parseInt(error));
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Display Error Register on the controller (index 1001).")
    public String displayErrorRegister() {
        String errorInHexa = this.readErrorRegister();
        String errorName = CanOpenErrorsTable.getErrorRegisterNameByCode(errorInHexa);
        FCSCst.FCSLOG.debug((Object)("error register=" + errorInHexa + " error name=" + errorName));
        return errorName;
    }

    public String[] readErrorHistory() {
        int numberOfErrors = this.readNumberOfErrors();
        String[] errors = new String[numberOfErrors];
        for (int i = 0; i < numberOfErrors; ++i) {
            String subindex = Integer.toHexString(i + 1);
            try {
                errors[i] = this.readSDO("1003", subindex);
                continue;
            }
            catch (CanOpenCallTimeoutException ex) {
                String msg = " timeout expired while waiting to a response  to command: readErrorHistory - POWER FAILURE ? ";
                this.raiseWarning(this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription(), msg + (Object)((Object)ex));
            }
        }
        return errors;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Display Error Register on the controller (index 1001).")
    public String displayErrorHistory() {
        this.errorHistory = this.readErrorHistory();
        StringBuilder sb = new StringBuilder("Error history contains " + this.errorHistory.length + " errors.");
        if (this.errorHistory.length != 0) {
            sb.append("\nList of errors in history,the newest is the first, the oldest the last :\n");
            for (int ix = 0; ix < this.errorHistory.length; ++ix) {
                sb.append("Error code (in hexa)=");
                sb.append(this.errorHistory[ix]);
                sb.append("/ error name= ");
                sb.append(CanOpenErrorsTable.getDeviceErrorNameByCode(this.errorHistory[ix]));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read and returns the number of errors registred in the Error History.")
    public int readNumberOfErrors() {
        String errorNBinHEXA = this.readSDO("1003", "0");
        return Integer.parseInt(errorNBinHEXA, 16);
    }

    public String[] readErrorHistoryNames() throws FcsHardwareException {
        String[] errorHistoryList = this.readErrorHistory();
        String[] errorHistoryNames = new String[errorHistoryList.length];
        if (errorHistoryList.length != 0) {
            for (int i = 0; i < errorHistoryList.length; ++i) {
                String errorCode = errorHistoryList[i];
                FCSCst.FCSLOG.debug((Object)("errorCode=" + errorCode));
                String errorName = CanOpenErrorsTable.getDeviceErrorNameByCode(errorCode);
                FCSCst.FCSLOG.debug((Object)("errorName=" + errorName));
                errorHistoryNames[i] = errorCode + "=" + errorName;
            }
        }
        return errorHistoryNames;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This method saves the parameters in the controller memory.")
    public Object saveParameters() {
        return this.writeSDO("1010", "1", "4", "65766173");
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Configure a CANopen device as a heartbeat producer.")
    public String configAsHeartbeatProducer(String nodeID, String heartbeatTime) {
        return this.tcpProxy.writeSDO(nodeID, "1017", "0", "2", heartbeatTime);
    }

    public String configAsHeartbeatProducer(int nodeID, int heartbeatTime) {
        if (heartbeatTime < 0 || heartbeatTime > 65535) {
            throw new IllegalArgumentException("heartbeat time is coded on 2 bytes can't be > 65535");
        }
        return this.configAsHeartbeatProducer(Integer.toHexString(nodeID), Integer.toHexString(heartbeatTime));
    }

    public String configAsHeartbeatConsumer(int nodeID, int producerNodeID, int heartbeatTime) {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and <=127");
        }
        if (producerNodeID < 0 || producerNodeID > 127) {
            throw new IllegalArgumentException("producerNodeID must be > 0 and <=127");
        }
        if (heartbeatTime < 0 || heartbeatTime > 65535) {
            throw new IllegalArgumentException("heartbeat time is coded on 2 bytes can't be > 65535");
        }
        String value = String.format("%04x", producerNodeID) + String.format("%04x", heartbeatTime);
        return this.tcpProxy.writeSDO(Integer.toHexString(nodeID), "1016", "1", "4", value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print CANopen device.")
    public String toString() {
        StringBuilder sb = this.getName() == null ? new StringBuilder() : new StringBuilder(this.getName());
        sb.append("/SerialNumber=");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(this.nodeID);
        int x = Integer.parseInt(this.nodeID, 16);
        sb.append("/NodeID_in_decimal=");
        sb.append(x);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isBooted()) {
            sb.append("BOOTED/");
        } else {
            sb.append("NOT YET BOOTED/");
        }
        return sb.toString();
    }

    public StatusDataPublishedByCanOpenDevice createStatusDataPublishedByCanOpenDevice() {
        StatusDataPublishedByCanOpenDevice status = new StatusDataPublishedByCanOpenDevice(this.getName(), this.isBooted(), this.initialized);
        status.setInError(this.inError);
        status.setErrorRegister(this.errorRegister);
        status.setErrorHistory(this.errorHistory);
        return status;
    }

    public StatusDataPublishedByCanOpenDevice getStatusData() {
        return this.createStatusDataPublishedByCanOpenDevice();
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="refreshGUI", description="Publish data for the device on the status bus.")
    public void publishData() {
        KeyValueData kvd = new KeyValueData(this.getName(), (Serializable)this.getStatusData());
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

